/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.system;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationPid;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class ApplicationPidListener
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(ApplicationPidListener.class);
    private static final String DEFAULT_FILE_NAME = "application.pid";
    private static final String[] PROPERTY_VARIABLES = new String[]{"PIDFILE", "pidfile"};
    private static final AtomicBoolean created = new AtomicBoolean(false);
    private int order = -2147483635;
    private final File file;

    public ApplicationPidListener() {
        this.file = new File(DEFAULT_FILE_NAME);
    }

    public ApplicationPidListener(String filename) {
        this(new File(filename));
    }

    public ApplicationPidListener(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        String override = this.getOverride();
        this.file = override != null ? new File(override) : file;
    }

    private String getOverride() {
        for (String property : PROPERTY_VARIABLES) {
            try {
                String override = System.getProperty(property);
                String string = override = override != null ? override : System.getenv(property);
                if (override == null) continue;
                return override;
            }
            catch (Throwable ex) {
                System.err.println("Could not resolve '" + property + "' as system property: " + ex);
            }
        }
        return null;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (created.compareAndSet(false, true)) {
            try {
                new ApplicationPid().write(this.file);
                this.file.deleteOnExit();
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("Cannot create pid file %s", this.file));
            }
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    static void reset() {
        created.set(false);
    }
}

