/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class DataSourceHealthIndicator
extends AbstractHealthIndicator {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private static Map<String, String> queries = new HashMap<String, String>();
    private static String DEFAULT_QUERY;
    private String query = null;

    public DataSourceHealthIndicator() {
    }

    public DataSourceHealthIndicator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.dataSource == null) {
            builder.up().withDetail("database", "unknown");
        } else {
            this.doDataSourceHealthCheck(builder);
        }
    }

    private void doDataSourceHealthCheck(Health.Builder builder) throws Exception {
        String product = this.getProduct();
        builder.up().withDetail("database", product);
        String query = this.detectQuery(product);
        if (StringUtils.hasText((String)query)) {
            try {
                builder.withDetail("hello", this.jdbcTemplate.queryForObject(query, Object.class));
            }
            catch (Exception ex) {
                builder.down(ex);
            }
        }
    }

    private String getProduct() {
        return (String)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getDatabaseProductName();
            }
        });
    }

    protected String detectQuery(String product) {
        String query = this.query;
        if (!StringUtils.hasText((String)query)) {
            query = queries.get(product);
        }
        if (!StringUtils.hasText((String)query)) {
            query = DEFAULT_QUERY;
        }
        return query;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    static {
        queries.put("HSQL Database Engine", "SELECT COUNT(*) FROM INFORMATION_SCHEMA.SYSTEM_USERS");
        queries.put("Oracle", "SELECT 'Hello' from DUAL");
        queries.put("Apache Derby", "SELECT 1 FROM SYSIBM.SYSDUMMY1");
        DEFAULT_QUERY = "SELECT 1";
    }
}

