/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebRequestTraceFilter
extends OncePerRequestFilter
implements Ordered {
    private final Log logger = LogFactory.getLog(WebRequestTraceFilter.class);
    private boolean dumpRequests = false;
    private int order = Integer.MAX_VALUE;
    private final TraceRepository traceRepository;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ErrorAttributes errorAttributes;

    public WebRequestTraceFilter(TraceRepository traceRepository) {
        this.traceRepository = traceRepository;
    }

    public void setDumpRequests(boolean dumpRequests) {
        this.dumpRequests = dumpRequests;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Map<String, Object> trace = this.getTrace(request);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing request " + request.getMethod() + " " + request.getRequestURI()));
            if (this.dumpRequests) {
                try {
                    Map headers = (Map)trace.get("headers");
                    this.logger.trace((Object)("Headers: " + this.objectMapper.writeValueAsString((Object)headers)));
                }
                catch (JsonProcessingException ex) {
                    throw new IllegalStateException("Cannot create JSON", ex);
                }
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.enhanceTrace(trace, response);
            this.traceRepository.add(trace);
        }
    }

    protected void enhanceTrace(Map<String, Object> trace, HttpServletResponse response) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (String header : response.getHeaderNames()) {
            String value = response.getHeader(header);
            headers.put(header, value);
        }
        headers.put("status", "" + response.getStatus());
        Map allHeaders = (Map)trace.get("headers");
        allHeaders.put("response", headers);
    }

    protected Map<String, Object> getTrace(HttpServletRequest request) {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = Collections.list(request.getHeaders(name));
            Object value = values;
            if (values.size() == 1) {
                value = values.get(0);
            } else if (values.isEmpty()) {
                value = "";
            }
            headers.put(name, value);
        }
        LinkedHashMap<String, Object> trace = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> allHeaders = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        allHeaders.put("request", headers);
        trace.put("method", request.getMethod());
        trace.put("path", request.getRequestURI());
        trace.put("headers", allHeaders);
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception != null && this.errorAttributes != null) {
            ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
            Map error = this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, true);
            trace.put("error", error);
        }
        return trace;
    }

    public void setErrorAttributes(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }
}

