/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class SystemPublicMetrics
implements PublicMetrics,
Ordered {
    private long timestamp = System.currentTimeMillis();

    public int getOrder() {
        return -2147483638;
    }

    @Override
    public Collection<Metric<?>> metrics() {
        LinkedHashSet result = new LinkedHashSet();
        this.addBasicMetrics(result);
        this.addHeapMetrics(result);
        this.addThreadMetrics(result);
        this.addClassLoadingMetrics(result);
        this.addGarbageCollectionMetrics(result);
        return result;
    }

    protected void addBasicMetrics(Collection<Metric<?>> result) {
        result.add(new Metric<Long>("mem", Runtime.getRuntime().totalMemory() / 1024L));
        result.add(new Metric<Long>("mem.free", Runtime.getRuntime().freeMemory() / 1024L));
        result.add(new Metric<Integer>("processors", Runtime.getRuntime().availableProcessors()));
        result.add(new Metric<Long>("uptime", ManagementFactory.getRuntimeMXBean().getUptime()));
        result.add(new Metric<Long>("instance.uptime", System.currentTimeMillis() - this.timestamp));
        result.add(new Metric<Double>("systemload.average", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage()));
    }

    protected void addHeapMetrics(Collection<Metric<?>> result) {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        result.add(new Metric<Long>("heap.committed", memoryUsage.getCommitted() / 1024L));
        result.add(new Metric<Long>("heap.init", memoryUsage.getInit() / 1024L));
        result.add(new Metric<Long>("heap.used", memoryUsage.getUsed() / 1024L));
        result.add(new Metric<Long>("heap", memoryUsage.getMax() / 1024L));
    }

    protected void addThreadMetrics(Collection<Metric<?>> result) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        result.add(new Metric<Long>("threads.peak", Long.valueOf(threadMxBean.getPeakThreadCount())));
        result.add(new Metric<Long>("threads.daemon", Long.valueOf(threadMxBean.getDaemonThreadCount())));
        result.add(new Metric<Long>("threads", Long.valueOf(threadMxBean.getThreadCount())));
    }

    protected void addClassLoadingMetrics(Collection<Metric<?>> result) {
        ClassLoadingMXBean classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
        result.add(new Metric<Long>("classes", Long.valueOf(classLoadingMxBean.getLoadedClassCount())));
        result.add(new Metric<Long>("classes.loaded", classLoadingMxBean.getTotalLoadedClassCount()));
        result.add(new Metric<Long>("classes.unloaded", classLoadingMxBean.getUnloadedClassCount()));
    }

    protected void addGarbageCollectionMetrics(Collection<Metric<?>> result) {
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMxBeans) {
            String name = this.beautifyGcName(garbageCollectorMXBean.getName());
            result.add(new Metric<Long>("gc." + name + ".count", garbageCollectorMXBean.getCollectionCount()));
            result.add(new Metric<Long>("gc." + name + ".time", garbageCollectorMXBean.getCollectionTime()));
        }
    }

    private String beautifyGcName(String name) {
        return StringUtils.replace((String)name, (String)" ", (String)"_").toLowerCase();
    }
}

