/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.reader;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Timer;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class MetricRegistryMetricReader
implements MetricReader,
MetricRegistryListener {
    private static Map<Class<?>, Set<String>> numberKeys = new ConcurrentHashMap();
    private MetricRegistry registry;
    private Map<String, String> names = new HashMap<String, String>();
    private MultiValueMap<String, String> reverse = new LinkedMultiValueMap();

    public MetricRegistryMetricReader(MetricRegistry registry) {
        this.registry = registry;
        registry.addListener((MetricRegistryListener)this);
    }

    @Override
    public Metric<?> findOne(String metricName) {
        if (!this.names.containsKey(metricName)) {
            return null;
        }
        com.codahale.metrics.Metric metric = (com.codahale.metrics.Metric)this.registry.getMetrics().get(this.names.get(metricName));
        if (metric instanceof Counter) {
            Counter counter = (Counter)metric;
            return new Metric<Long>(metricName, counter.getCount());
        }
        if (metric instanceof Gauge) {
            Gauge value = (Gauge)metric;
            return new Metric<Number>(metricName, (Number)value.getValue());
        }
        if (metric instanceof Sampling && metricName.contains(".snapshot.")) {
            Number value = MetricRegistryMetricReader.getMetric(((Sampling)metric).getSnapshot(), metricName);
            if (metric instanceof Timer) {
                value = TimeUnit.MILLISECONDS.convert(value.longValue(), TimeUnit.NANOSECONDS);
            }
            return new Metric<Number>(metricName, value);
        }
        return new Metric<Number>(metricName, MetricRegistryMetricReader.getMetric(metric, metricName));
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        return new Iterable<Metric<?>>(){

            @Override
            public Iterator<Metric<?>> iterator() {
                return new MetricRegistryIterator();
            }
        };
    }

    @Override
    public long count() {
        return this.names.size();
    }

    public void onGaugeAdded(String name, Gauge<?> gauge) {
        this.names.put(name, name);
        this.reverse.add((Object)name, (Object)name);
    }

    public void onGaugeRemoved(String name) {
        this.remove(name);
    }

    public void onCounterAdded(String name, Counter counter) {
        this.names.put(name, name);
        this.reverse.add((Object)name, (Object)name);
    }

    public void onCounterRemoved(String name) {
        this.remove(name);
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        String metricName;
        for (String key : MetricRegistryMetricReader.getNumberKeys(histogram)) {
            metricName = name + "." + key;
            this.names.put(metricName, name);
            this.reverse.add((Object)name, (Object)metricName);
        }
        for (String key : MetricRegistryMetricReader.getNumberKeys(histogram.getSnapshot())) {
            metricName = name + ".snapshot." + key;
            this.names.put(metricName, name);
            this.reverse.add((Object)name, (Object)metricName);
        }
    }

    public void onHistogramRemoved(String name) {
        this.remove(name);
    }

    public void onMeterAdded(String name, Meter meter) {
        for (String key : MetricRegistryMetricReader.getNumberKeys(meter)) {
            String metricName = name + "." + key;
            this.names.put(metricName, name);
            this.reverse.add((Object)name, (Object)metricName);
        }
    }

    public void onMeterRemoved(String name) {
        this.remove(name);
    }

    public void onTimerAdded(String name, Timer timer) {
        String metricName;
        for (String key : MetricRegistryMetricReader.getNumberKeys(timer)) {
            metricName = name + "." + key;
            this.names.put(metricName, name);
            this.reverse.add((Object)name, (Object)metricName);
        }
        for (String key : MetricRegistryMetricReader.getNumberKeys(timer.getSnapshot())) {
            metricName = name + ".snapshot." + key;
            this.names.put(metricName, name);
            this.reverse.add((Object)name, (Object)metricName);
        }
    }

    public void onTimerRemoved(String name) {
        this.remove(name);
    }

    private void remove(String name) {
        for (String key : (List)this.reverse.get((Object)name)) {
            this.names.remove(name + "." + key);
        }
        this.reverse.remove((Object)name);
    }

    private static Set<String> getNumberKeys(Object metric) {
        HashSet<String> result;
        Set<String> set = result = numberKeys.containsKey(metric.getClass()) ? numberKeys.get(metric.getClass()) : new HashSet<String>();
        if (result.isEmpty()) {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(metric.getClass())) {
                if (!ClassUtils.isAssignable(Number.class, descriptor.getPropertyType())) continue;
                result.add(descriptor.getName());
            }
            numberKeys.put(metric.getClass(), result);
        }
        return result;
    }

    private static Number getMetric(Object metric, String metricName) {
        String key = StringUtils.getFilenameExtension((String)metricName);
        return (Number)new BeanWrapperImpl(metric).getPropertyValue(key);
    }

    private class MetricRegistryIterator
    implements Iterator<Metric<?>> {
        private Iterator<String> iterator;

        public MetricRegistryIterator() {
            this.iterator = new HashSet(MetricRegistryMetricReader.this.names.keySet()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Metric<?> next() {
            String name = this.iterator.next();
            return MetricRegistryMetricReader.this.findOne(name);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("You cannot remove from this iterator.");
        }
    }
}

