/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import com.google.common.cache.Cache;
import com.hazelcast.core.IMap;
import com.hazelcast.spring.cache.HazelcastCache;
import javax.cache.Caching;
import net.sf.ehcache.Ehcache;
import org.infinispan.spring.provider.SpringCache;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.boot.actuate.cache.ConcurrentMapCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.DefaultCacheStatistics;
import org.springframework.boot.actuate.cache.EhCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.GuavaCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.HazelcastCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.InfinispanCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.JCacheCacheStatisticsProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
@ConditionalOnBean(value={CacheManager.class})
public class CacheStatisticsAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={NoOpCacheManager.class})
    static class NoOpCacheStatisticsConfiguration {
        private static final CacheStatistics NO_OP_STATS = new DefaultCacheStatistics();

        NoOpCacheStatisticsConfiguration() {
        }

        @Bean
        public CacheStatisticsProvider<org.springframework.cache.Cache> noOpCacheStatisticsProvider() {
            return new CacheStatisticsProvider<org.springframework.cache.Cache>(){

                @Override
                public CacheStatistics getCacheStatistics(CacheManager cacheManager, org.springframework.cache.Cache cache) {
                    if (cacheManager instanceof NoOpCacheManager) {
                        return NO_OP_STATS;
                    }
                    return null;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={ConcurrentMapCache.class})
    static class ConcurrentMapCacheStatisticsConfiguration {
        ConcurrentMapCacheStatisticsConfiguration() {
        }

        @Bean
        public ConcurrentMapCacheStatisticsProvider concurrentMapCacheStatisticsProvider() {
            return new ConcurrentMapCacheStatisticsProvider();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cache.class})
    static class GuavaCacheStatisticsConfiguration {
        GuavaCacheStatisticsConfiguration() {
        }

        @Bean
        public GuavaCacheStatisticsProvider guavaCacheStatisticsProvider() {
            return new GuavaCacheStatisticsProvider();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringCache.class})
    static class InfinispanCacheStatisticsProviderConfiguration {
        InfinispanCacheStatisticsProviderConfiguration() {
        }

        @Bean
        public InfinispanCacheStatisticsProvider infinispanCacheStatisticsProvider() {
            return new InfinispanCacheStatisticsProvider();
        }
    }

    @Configuration
    @ConditionalOnClass(value={IMap.class, HazelcastCache.class})
    static class HazelcastCacheStatisticsConfiguration {
        HazelcastCacheStatisticsConfiguration() {
        }

        @Bean
        public HazelcastCacheStatisticsProvider hazelcastCacheStatisticsProvider() {
            return new HazelcastCacheStatisticsProvider();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Ehcache.class})
    static class EhCacheCacheStatisticsProviderConfiguration {
        EhCacheCacheStatisticsProviderConfiguration() {
        }

        @Bean
        public EhCacheStatisticsProvider ehCacheCacheStatisticsProvider() {
            return new EhCacheStatisticsProvider();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Caching.class, JCacheCache.class})
    static class JCacheCacheStatisticsProviderConfiguration {
        JCacheCacheStatisticsProviderConfiguration() {
        }

        @Bean
        public JCacheCacheStatisticsProvider jCacheCacheStatisticsProvider() {
            return new JCacheCacheStatisticsProvider();
        }
    }
}

