/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.io.IOException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.logfile")
public class LogFileMvcEndpoint
implements MvcEndpoint,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(LogFileMvcEndpoint.class);
    @NotNull
    @Pattern(regexp="/[^/]*", message="Path must start with /")
    private String path = "/logfile";
    private boolean sensitive = true;
    private boolean enabled = true;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }

    @RequestMapping(method={RequestMethod.HEAD})
    @ResponseBody
    public ResponseEntity<?> available() {
        return this.getResponse(false);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> invoke() throws IOException {
        return this.getResponse(true);
    }

    private ResponseEntity<?> getResponse(boolean includeBody) {
        if (!this.isEnabled()) {
            return includeBody ? DISABLED_RESPONSE : ResponseEntity.notFound().build();
        }
        Resource resource = this.getLogFileResource();
        if (resource == null) {
            return ResponseEntity.notFound().build();
        }
        ResponseEntity.BodyBuilder response = ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN);
        return includeBody ? response.body((Object)resource) : response.build();
    }

    private Resource getLogFileResource() {
        LogFile logFile = LogFile.get((PropertyResolver)this.environment);
        if (logFile == null) {
            logger.debug((Object)"Missing 'logging.file' or 'logging.path' properties");
            return null;
        }
        FileSystemResource resource = new FileSystemResource(logFile.toString());
        if (!resource.exists()) {
            if (logger.isWarnEnabled()) {
                logger.debug((Object)("Log file '" + resource + "' does not exist"));
            }
            return null;
        }
        return resource;
    }
}

