/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@ConfigurationProperties(value="endpoints.actuator")
public class ActuatorHalJsonEndpoint
extends WebMvcConfigurerAdapter
implements MvcEndpoint {
    @NotNull
    @Pattern(regexp="^$|/[^/]*", message="Path must be empty or start with /")
    private String path;
    private boolean sensitive = false;
    private boolean enabled = true;
    private final ManagementServletContext managementServletContext;

    public ActuatorHalJsonEndpoint(ManagementServletContext managementServletContext) {
        this.managementServletContext = managementServletContext;
        this.path = this.getDefaultPath(managementServletContext);
    }

    private String getDefaultPath(ManagementServletContext managementServletContext) {
        if (StringUtils.hasText((String)managementServletContext.getContextPath())) {
            this.path = "";
            return "";
        }
        return "/actuator";
    }

    @RequestMapping(produces={"application/json"})
    @ResponseBody
    public ResourceSupport links() {
        return new ResourceSupport();
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Class<? extends Endpoint<?>> getEndpointType() {
        return null;
    }

    protected final ManagementServletContext getManagementServletContext() {
        return this.managementServletContext;
    }
}

