/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.actuate.metrics.export.SpecificTriggerProperties;
import org.springframework.boot.actuate.metrics.export.TriggerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.PatternMatchUtils;

@ConfigurationProperties(value="spring.metrics.export")
public class MetricExportProperties
extends TriggerProperties {
    private Map<String, SpecificTriggerProperties> triggers = new LinkedHashMap<String, SpecificTriggerProperties>();
    private Aggregate aggregate = new Aggregate();
    private Redis redis = new Redis();

    @PostConstruct
    public void setUpDefaults() {
        MetricExportProperties defaults = this;
        for (Map.Entry<String, SpecificTriggerProperties> entry : this.triggers.entrySet()) {
            String key = entry.getKey();
            SpecificTriggerProperties value = entry.getValue();
            if (value.getNames() != null && value.getNames().length != 0) continue;
            value.setNames(new String[]{key});
        }
        if (defaults.isSendLatest() == null) {
            defaults.setSendLatest(true);
        }
        if (defaults.getDelayMillis() == null) {
            defaults.setDelayMillis(5000L);
        }
        for (TriggerProperties triggerProperties : this.triggers.values()) {
            if (triggerProperties.isSendLatest() == null) {
                triggerProperties.setSendLatest(defaults.isSendLatest());
            }
            if (triggerProperties.getDelayMillis() != null) continue;
            triggerProperties.setDelayMillis(defaults.getDelayMillis());
        }
    }

    public Map<String, SpecificTriggerProperties> getTriggers() {
        return this.triggers;
    }

    public Redis getRedis() {
        return this.redis;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public TriggerProperties findTrigger(String name) {
        for (SpecificTriggerProperties value : this.triggers.values()) {
            if (!PatternMatchUtils.simpleMatch((String[])value.getNames(), (String)name)) continue;
            return value;
        }
        return this;
    }

    public static class Redis {
        private String prefix = "spring.metrics";
        private String key = "keys.spring.metrics";

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getAggregatePrefix() {
            if (this.key.startsWith("keys.")) {
                String candidate = this.key.substring("keys.".length());
                if (this.prefix.startsWith(candidate)) {
                    return candidate;
                }
                return candidate;
            }
            if (this.prefix.contains(".") && this.prefix.indexOf(".") < this.prefix.length() - 1) {
                return this.prefix.substring(this.prefix.indexOf(".") + 1);
            }
            return this.prefix;
        }
    }

    public static class Aggregate {
        private String prefix = "";
        private String keyPattern = "";

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getKeyPattern() {
            return this.keyPattern;
        }

        public void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }
    }
}

