/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthAggregator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.Assert;

public class OrderedHealthAggregator
extends AbstractHealthAggregator {
    private List<String> statusOrder;

    public OrderedHealthAggregator() {
        this.setStatusOrder(Status.DOWN, Status.OUT_OF_SERVICE, Status.UP, Status.UNKNOWN);
    }

    public void setStatusOrder(Status ... statusOrder) {
        String[] order = new String[statusOrder.length];
        for (int i = 0; i < statusOrder.length; ++i) {
            order[i] = statusOrder[i].getCode();
        }
        this.setStatusOrder(Arrays.asList(order));
    }

    public void setStatusOrder(List<String> statusOrder) {
        Assert.notNull(statusOrder, (String)"StatusOrder must not be null");
        this.statusOrder = statusOrder;
    }

    @Override
    protected Status aggregateStatus(List<Status> candidates) {
        ArrayList<Status> filteredCandidates = new ArrayList<Status>();
        for (Status candidate : candidates) {
            if (!this.statusOrder.contains(candidate.getCode())) continue;
            filteredCandidates.add(candidate);
        }
        if (filteredCandidates.size() == 0) {
            return Status.UNKNOWN;
        }
        Collections.sort(filteredCandidates, new StatusComparator(this.statusOrder));
        return (Status)filteredCandidates.get(0);
    }

    private class StatusComparator
    implements Comparator<Status> {
        private final List<String> statusOrder;

        StatusComparator(List<String> statusOrder) {
            this.statusOrder = statusOrder;
        }

        @Override
        public int compare(Status s1, Status s2) {
            int i2;
            int i1 = this.statusOrder.indexOf(s1.getCode());
            return i1 < (i2 = this.statusOrder.indexOf(s2.getCode())) ? -1 : (i1 == i2 ? s1.getCode().compareTo(s2.getCode()) : 1);
        }
    }
}

