/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.reader;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Timer;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class MetricRegistryMetricReader
implements MetricReader,
MetricRegistryListener {
    private static Log logger = LogFactory.getLog(MetricRegistryMetricReader.class);
    private static final Map<Class<?>, Set<String>> numberKeys = new ConcurrentHashMap();
    private final Object monitor = new Object();
    private final Map<String, String> names = new ConcurrentHashMap<String, String>();
    private final MultiValueMap<String, String> reverse = new LinkedMultiValueMap();
    private final MetricRegistry registry;

    public MetricRegistryMetricReader(MetricRegistry registry) {
        this.registry = registry;
        registry.addListener((MetricRegistryListener)this);
    }

    @Override
    public Metric<?> findOne(String metricName) {
        String name = this.names.get(metricName);
        if (name == null) {
            return null;
        }
        com.codahale.metrics.Metric metric = (com.codahale.metrics.Metric)this.registry.getMetrics().get(name);
        if (metric == null) {
            return null;
        }
        if (metric instanceof Counter) {
            Counter counter = (Counter)metric;
            return new Metric<Long>(metricName, counter.getCount());
        }
        if (metric instanceof Gauge) {
            Gauge value = (Gauge)metric;
            return new Metric<Number>(metricName, (Number)value.getValue());
        }
        if (metric instanceof Sampling && metricName.contains(".snapshot.")) {
            Number value = MetricRegistryMetricReader.getMetric(((Sampling)metric).getSnapshot(), metricName);
            if (metric instanceof Timer) {
                value = TimeUnit.MILLISECONDS.convert(value.longValue(), TimeUnit.NANOSECONDS);
            }
            return new Metric<Number>(metricName, value);
        }
        return new Metric<Number>(metricName, MetricRegistryMetricReader.getMetric(metric, metricName));
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        return new Iterable<Metric<?>>(){

            @Override
            public Iterator<Metric<?>> iterator() {
                HashSet metrics = new HashSet();
                for (String name : MetricRegistryMetricReader.this.names.keySet()) {
                    Metric<?> metric = MetricRegistryMetricReader.this.findOne(name);
                    if (metric == null) continue;
                    metrics.add(metric);
                }
                return metrics.iterator();
            }
        };
    }

    @Override
    public long count() {
        return this.names.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGaugeAdded(String name, Gauge<?> gauge) {
        if (!(gauge.getValue() instanceof Number)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring gauge '" + name + "' (" + gauge + ") as its value is not a Number"));
            }
            return;
        }
        this.names.put(name, name);
        Object object = this.monitor;
        synchronized (object) {
            this.reverse.add((Object)name, (Object)name);
        }
    }

    public void onGaugeRemoved(String name) {
        this.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCounterAdded(String name, Counter counter) {
        this.names.put(name, name);
        Object object = this.monitor;
        synchronized (object) {
            this.reverse.add((Object)name, (Object)name);
        }
    }

    public void onCounterRemoved(String name) {
        this.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHistogramAdded(String name, Histogram histogram) {
        Object object;
        String metricName;
        for (String key : MetricRegistryMetricReader.getNumberKeys(histogram)) {
            metricName = name + "." + key;
            this.names.put(metricName, name);
            object = this.monitor;
            synchronized (object) {
                this.reverse.add((Object)name, (Object)metricName);
            }
        }
        for (String key : MetricRegistryMetricReader.getNumberKeys(histogram.getSnapshot())) {
            metricName = name + ".snapshot." + key;
            this.names.put(metricName, name);
            object = this.monitor;
            synchronized (object) {
                this.reverse.add((Object)name, (Object)metricName);
            }
        }
    }

    public void onHistogramRemoved(String name) {
        this.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMeterAdded(String name, Meter meter) {
        for (String key : MetricRegistryMetricReader.getNumberKeys(meter)) {
            String metricName = name + "." + key;
            this.names.put(metricName, name);
            Object object = this.monitor;
            synchronized (object) {
                this.reverse.add((Object)name, (Object)metricName);
            }
        }
    }

    public void onMeterRemoved(String name) {
        this.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimerAdded(String name, Timer timer) {
        Object object;
        String metricName;
        for (String key : MetricRegistryMetricReader.getNumberKeys(timer)) {
            metricName = name + "." + key;
            this.names.put(metricName, name);
            object = this.monitor;
            synchronized (object) {
                this.reverse.add((Object)name, (Object)metricName);
            }
        }
        for (String key : MetricRegistryMetricReader.getNumberKeys(timer.getSnapshot())) {
            metricName = name + ".snapshot." + key;
            this.names.put(metricName, name);
            object = this.monitor;
            synchronized (object) {
                this.reverse.add((Object)name, (Object)metricName);
            }
        }
    }

    public void onTimerRemoved(String name) {
        this.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String name) {
        List keys;
        Iterator iterator = this.monitor;
        synchronized (iterator) {
            keys = (List)this.reverse.remove((Object)name);
        }
        if (keys != null) {
            for (String key : keys) {
                this.names.remove(name + "." + key);
            }
        }
    }

    private static Set<String> getNumberKeys(Object metric) {
        Set<String> result = numberKeys.get(metric.getClass());
        if (result == null) {
            result = new HashSet<String>();
        }
        if (result.isEmpty()) {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(metric.getClass())) {
                if (!ClassUtils.isAssignable(Number.class, descriptor.getPropertyType())) continue;
                result.add(descriptor.getName());
            }
            numberKeys.put(metric.getClass(), result);
        }
        return result;
    }

    private static Number getMetric(Object metric, String metricName) {
        String key = StringUtils.getFilenameExtension((String)metricName);
        return (Number)new BeanWrapperImpl(metric).getPropertyValue(key);
    }
}

