/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

@Order(value=0x7FFFFFFF)
class ManagementContextConfigurationsImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware {
    private ClassLoader classLoader;

    ManagementContextConfigurationsImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        List<String> names = this.loadFactoryNames();
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        for (String factoryName : names) {
            classes.add(ClassUtils.resolveClassName((String)factoryName, (ClassLoader)this.classLoader));
        }
        return this.getSortedClassNames(new ArrayList(classes));
    }

    protected List<String> loadFactoryNames() {
        return SpringFactoriesLoader.loadFactoryNames(ManagementContextConfiguration.class, (ClassLoader)this.classLoader);
    }

    private String[] getSortedClassNames(List<Class<?>> classes) {
        AnnotationAwareOrderComparator.sort(classes);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> sourceClass : classes) {
            names.add(sourceClass.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

