/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management.shell", ignoreUnknownFields=true)
@Deprecated
public class ShellProperties {
    public static final String SHELL_PREFIX = "management.shell";
    private static final Log logger = LogFactory.getLog(ShellProperties.class);
    private final Auth auth = new Auth();
    @Autowired(required=false)
    private CrshShellProperties[] additionalProperties = new CrshShellProperties[]{new SimpleAuthenticationProperties()};
    private int commandRefreshInterval = -1;
    private String[] commandPathPatterns = new String[]{"classpath*:/commands/**", "classpath*:/crash/commands/**"};
    private String[] configPathPatterns = new String[]{"classpath*:/crash/*"};
    private String[] disabledCommands = new String[]{"jpa*", "jdbc*", "jndi*"};
    private String[] disabledPlugins = new String[0];
    private final Ssh ssh = new Ssh();
    private final Telnet telnet = new Telnet();

    public Auth getAuth() {
        return this.auth;
    }

    public CrshShellProperties[] getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setCommandRefreshInterval(int commandRefreshInterval) {
        this.commandRefreshInterval = commandRefreshInterval;
    }

    public int getCommandRefreshInterval() {
        return this.commandRefreshInterval;
    }

    public void setCommandPathPatterns(String[] commandPathPatterns) {
        Assert.notEmpty((Object[])commandPathPatterns, (String)"CommandPathPatterns must not be empty");
        this.commandPathPatterns = commandPathPatterns;
    }

    public String[] getCommandPathPatterns() {
        return this.commandPathPatterns;
    }

    public void setConfigPathPatterns(String[] configPathPatterns) {
        Assert.notEmpty((Object[])configPathPatterns, (String)"ConfigPathPatterns must not be empty");
        this.configPathPatterns = configPathPatterns;
    }

    public String[] getConfigPathPatterns() {
        return this.configPathPatterns;
    }

    public void setDisabledCommands(String[] disabledCommands) {
        Assert.notEmpty((Object[])disabledCommands, (String)"disabledCommands must not be empty");
        this.disabledCommands = disabledCommands;
    }

    public String[] getDisabledCommands() {
        return this.disabledCommands;
    }

    public void setDisabledPlugins(String[] disabledPlugins) {
        Assert.notEmpty((Object[])disabledPlugins, (String)"disabledPlugins must not be empty");
        this.disabledPlugins = disabledPlugins;
    }

    public String[] getDisabledPlugins() {
        return this.disabledPlugins;
    }

    public Ssh getSsh() {
        return this.ssh;
    }

    public Telnet getTelnet() {
        return this.telnet;
    }

    public Properties asCrshShellConfig() {
        Properties properties = new Properties();
        this.ssh.applyToCrshShellConfig(properties);
        this.telnet.applyToCrshShellConfig(properties);
        for (CrshShellProperties shellProperties : this.additionalProperties) {
            shellProperties.applyToCrshShellConfig(properties);
        }
        if (this.commandRefreshInterval > 0) {
            properties.put("crash.vfs.refresh_period", String.valueOf(this.commandRefreshInterval));
        }
        ArrayList<String> dp = new ArrayList<String>(Arrays.asList(this.disabledPlugins));
        if (!this.ssh.isEnabled()) {
            dp.add("org.crsh.ssh.SSHPlugin");
        }
        if (!this.telnet.isEnabled()) {
            dp.add("org.crsh.telnet.TelnetPlugin");
        }
        this.disabledPlugins = dp.toArray(new String[dp.size()]);
        this.validateCrshShellConfig(properties);
        return properties;
    }

    protected void validateCrshShellConfig(Properties properties) {
        this.getAuth().validateCrshShellConfig(properties);
    }

    @ConfigurationProperties(prefix="management.shell.auth.spring", ignoreUnknownFields=false)
    public static class SpringAuthenticationProperties
    extends CrshShellAuthenticationProperties {
        private String[] roles = new String[]{"ACTUATOR"};

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            config.put("crash.auth", "spring");
            config.put("crash.auth.spring.roles", StringUtils.arrayToCommaDelimitedString((Object[])this.roles));
        }

        public void setRoles(String[] roles) {
            this.roles = roles;
        }

        public String[] getRoles() {
            return this.roles;
        }
    }

    @ConfigurationProperties(prefix="management.shell.auth.simple", ignoreUnknownFields=false)
    public static class SimpleAuthenticationProperties
    extends CrshShellAuthenticationProperties {
        private static final Log logger = LogFactory.getLog(SimpleAuthenticationProperties.class);
        private User user = new User();

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            config.put("crash.auth", "simple");
            config.put("crash.auth.simple.username", this.user.getName());
            config.put("crash.auth.simple.password", this.user.getPassword());
            if (this.user.isDefaultPassword()) {
                logger.info((Object)String.format("%n%nUsing default password for shell access: %s%n%n", this.user.getPassword()));
            }
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public static class User {
            private String name = "user";
            private String password = UUID.randomUUID().toString();
            private boolean defaultPassword = true;

            boolean isDefaultPassword() {
                return this.defaultPassword;
            }

            public String getName() {
                return this.name;
            }

            public String getPassword() {
                return this.password;
            }

            public void setName(String name) {
                Assert.hasLength((String)name, (String)"name must have text");
                this.name = name;
            }

            public void setPassword(String password) {
                if (password.startsWith("${") && password.endsWith("}") || !StringUtils.hasLength((String)password)) {
                    return;
                }
                this.password = password;
                this.defaultPassword = false;
            }
        }
    }

    @ConfigurationProperties(prefix="management.shell.auth.key", ignoreUnknownFields=false)
    public static class KeyAuthenticationProperties
    extends CrshShellAuthenticationProperties {
        private String path;

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            config.put("crash.auth", "key");
            if (this.path != null) {
                config.put("crash.auth.key.path", this.path);
            }
        }

        public void setPath(String path) {
            Assert.hasText((String)path, (String)"path must have text");
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    @ConfigurationProperties(prefix="management.shell.auth.jaas", ignoreUnknownFields=false)
    public static class JaasAuthenticationProperties
    extends CrshShellAuthenticationProperties {
        private String domain = "my-domain";

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            config.put("crash.auth", "jaas");
            config.put("crash.auth.jaas.domain", this.domain);
        }

        public void setDomain(String domain) {
            Assert.hasText((String)domain, (String)"domain must have text");
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }
    }

    public static class Telnet
    extends CrshShellProperties {
        private boolean enabled = ClassUtils.isPresent((String)"org.crsh.telnet.TelnetPlugin", (ClassLoader)ClassUtils.getDefaultClassLoader());
        private Integer port = 5000;

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            if (this.enabled) {
                config.put("crash.telnet.port", String.valueOf(this.port));
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setPort(Integer port) {
            Assert.notNull((Object)port, (String)"port must not be null");
            this.port = port;
        }

        public Integer getPort() {
            return this.port;
        }
    }

    public static class Ssh
    extends CrshShellProperties {
        private boolean enabled = true;
        private String keyPath;
        private Integer port = 2000;
        private Integer authTimeout = 600000;
        private Integer idleTimeout = 600000;

        @Override
        protected void applyToCrshShellConfig(Properties config) {
            if (this.enabled) {
                config.put("crash.ssh.port", String.valueOf(this.port));
                config.put("crash.ssh.auth_timeout", String.valueOf(this.authTimeout));
                config.put("crash.ssh.idle_timeout", String.valueOf(this.idleTimeout));
                if (this.keyPath != null) {
                    config.put("crash.ssh.keypath", this.keyPath);
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setKeyPath(String keyPath) {
            Assert.hasText((String)keyPath, (String)"keyPath must have text");
            this.keyPath = keyPath;
        }

        public String getKeyPath() {
            return this.keyPath;
        }

        public void setPort(Integer port) {
            Assert.notNull((Object)port, (String)"port must not be null");
            this.port = port;
        }

        public Integer getPort() {
            return this.port;
        }

        public Integer getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public Integer getAuthTimeout() {
            return this.authTimeout;
        }

        public void setAuthTimeout(Integer authTimeout) {
            this.authTimeout = authTimeout;
        }
    }

    public static class Auth {
        private String type = "simple";
        private boolean defaultAuth = true;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            Assert.hasLength((String)type, (String)"Auth type must not be empty");
            this.type = type;
            this.defaultAuth = false;
        }

        protected void validateCrshShellConfig(Properties properties) {
            String finalAuth = properties.getProperty("crash.auth");
            if (!this.defaultAuth && !this.type.equals(finalAuth)) {
                logger.warn((Object)String.format("Shell authentication fell back to method '%s' opposed to configured method '%s'. Please check your classpath.", finalAuth, this.type));
            }
            this.type = finalAuth;
        }
    }

    public static abstract class CrshShellAuthenticationProperties
    extends CrshShellProperties {
    }

    public static abstract class CrshShellProperties {
        protected abstract void applyToCrshShellConfig(Properties var1);
    }
}

