/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.regex.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public abstract class AbstractEndpoint<T>
implements Endpoint<T>,
EnvironmentAware {
    private static final Pattern ID_PATTERN = Pattern.compile("\\w+");
    private Environment environment;
    private String id;
    private final boolean sensitiveDefault;
    private Boolean sensitive;
    private Boolean enabled;

    public AbstractEndpoint(String id) {
        this(id, true);
    }

    public AbstractEndpoint(String id, boolean sensitive) {
        this.setId(id);
        this.sensitiveDefault = sensitive;
    }

    public AbstractEndpoint(String id, boolean sensitive, boolean enabled) {
        this.setId(id);
        this.sensitiveDefault = sensitive;
        this.enabled = enabled;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.isTrue((boolean)ID_PATTERN.matcher(id).matches(), (String)"Id must only contains letters, numbers and '_'");
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        return EndpointProperties.isEnabled(this.environment, this.enabled);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, this.sensitiveDefault);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }
}

