/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;
import org.springframework.util.Assert;

public class RichGaugeReaderPublicMetrics
implements PublicMetrics {
    private final RichGaugeReader richGaugeReader;

    public RichGaugeReaderPublicMetrics(RichGaugeReader richGaugeReader) {
        Assert.notNull((Object)richGaugeReader, (String)"RichGaugeReader must not be null");
        this.richGaugeReader = richGaugeReader;
    }

    @Override
    public Collection<Metric<?>> metrics() {
        ArrayList result = new ArrayList();
        for (RichGauge richGauge : this.richGaugeReader.findAll()) {
            result.addAll(this.convert(richGauge));
        }
        return result;
    }

    private List<Metric<?>> convert(RichGauge gauge) {
        ArrayList result = new ArrayList(6);
        result.add(new Metric<Double>(gauge.getName() + ".avg", gauge.getAverage()));
        result.add(new Metric<Double>(gauge.getName() + ".val", gauge.getValue()));
        result.add(new Metric<Double>(gauge.getName() + ".min", gauge.getMin()));
        result.add(new Metric<Double>(gauge.getName() + ".max", gauge.getMax()));
        result.add(new Metric<Double>(gauge.getName() + ".alpha", gauge.getAlpha()));
        result.add(new Metric<Long>(gauge.getName() + ".count", gauge.getCount()));
        return result;
    }
}

