/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.jmx.export.naming.KeyNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.util.StringUtils;

public class DefaultMetricNamingStrategy
implements ObjectNamingStrategy {
    private ObjectNamingStrategy namingStrategy = new KeyNamingStrategy();

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        ObjectName objectName = this.namingStrategy.getObjectName(managedBean, beanKey);
        String domain = objectName.getDomain();
        Hashtable<String, String> table = new Hashtable<String, String>(objectName.getKeyPropertyList());
        String name = objectName.getKeyProperty("name");
        if (name != null) {
            table.remove("name");
            String[] parts = StringUtils.delimitedListToStringArray((String)name, (String)".");
            table.put("type", parts[0]);
            if (parts.length > 1) {
                table.put(parts.length > 2 ? "name" : "value", parts[1]);
            }
            if (parts.length > 2) {
                table.put("value", name.substring(parts[0].length() + parts[1].length() + 2));
            }
        }
        return new ObjectName(domain, table);
    }
}

