/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.ManagementContextResolver;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.AuthenticationManagerConfiguration;
import org.springframework.boot.autoconfigure.security.FallbackWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.IgnoredRequestCustomizer;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityPrerequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.SpringBootWebSecurityConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={EnableWebSecurity.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
@AutoConfigureBefore(value={FallbackWebSecurityAutoConfiguration.class})
@EnableConfigurationProperties(value={ManagementServerProperties.class})
public class ManagementWebSecurityAutoConfiguration {
    private static final String[] NO_PATHS = new String[0];
    private static final RequestMatcher MATCH_NONE = new NegatedRequestMatcher(AnyRequestMatcher.INSTANCE);

    @Bean
    public IgnoredRequestCustomizer managementIgnoredRequestCustomizer(ManagementServerProperties management, ObjectProvider<ManagementContextResolver> contextResolver) {
        return new ManagementIgnoredRequestCustomizer(management, (ManagementContextResolver)contextResolver.getIfAvailable());
    }

    private static class LazyEndpointPathRequestMatcher
    implements RequestMatcher {
        private final EndpointPaths endpointPaths;
        private final ManagementContextResolver contextResolver;
        private RequestMatcher delegate;

        public static RequestMatcher getRequestMatcher(ManagementContextResolver contextResolver) {
            if (contextResolver == null) {
                return null;
            }
            ManagementServerProperties management = (ManagementServerProperties)contextResolver.getApplicationContext().getBean(ManagementServerProperties.class);
            ServerProperties server = (ServerProperties)contextResolver.getApplicationContext().getBean(ServerProperties.class);
            String path = management.getContextPath();
            if (StringUtils.hasText((String)path)) {
                AntPathRequestMatcher matcher = new AntPathRequestMatcher(server.getServlet().getPath(path) + "/**");
                return matcher;
            }
            return new LazyEndpointPathRequestMatcher(contextResolver, EndpointPaths.ALL);
        }

        LazyEndpointPathRequestMatcher(ManagementContextResolver contextResolver, EndpointPaths endpointPaths) {
            this.contextResolver = contextResolver;
            this.endpointPaths = endpointPaths;
        }

        public boolean matches(HttpServletRequest request) {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate.matches(request);
        }

        private RequestMatcher createDelegate() {
            ServerProperties server = (ServerProperties)this.contextResolver.getApplicationContext().getBean(ServerProperties.class);
            ArrayList<AntPathRequestMatcher> matchers = new ArrayList<AntPathRequestMatcher>();
            EndpointHandlerMapping endpointHandlerMapping = this.getRequiredEndpointHandlerMapping();
            for (String path : this.endpointPaths.getPaths(endpointHandlerMapping)) {
                matchers.add(new AntPathRequestMatcher(server.getServlet().getPath(path)));
            }
            return matchers.isEmpty() ? MATCH_NONE : new OrRequestMatcher(matchers);
        }

        private EndpointHandlerMapping getRequiredEndpointHandlerMapping() {
            EndpointHandlerMapping endpointHandlerMapping = null;
            ApplicationContext context = this.contextResolver.getApplicationContext();
            if (context.getBeanNamesForType(EndpointHandlerMapping.class).length > 0) {
                endpointHandlerMapping = (EndpointHandlerMapping)((Object)context.getBean(EndpointHandlerMapping.class));
            }
            if (endpointHandlerMapping == null) {
                endpointHandlerMapping = new EndpointHandlerMapping(Collections.emptySet());
            }
            return endpointHandlerMapping;
        }
    }

    private static enum EndpointPaths {
        ALL,
        NON_SENSITIVE{

            @Override
            protected boolean isIncluded(MvcEndpoint endpoint) {
                return !endpoint.isSensitive();
            }
        }
        ,
        SENSITIVE{

            @Override
            protected boolean isIncluded(MvcEndpoint endpoint) {
                return endpoint.isSensitive();
            }
        };


        public String[] getPaths(EndpointHandlerMapping endpointHandlerMapping) {
            if (endpointHandlerMapping == null) {
                return NO_PATHS;
            }
            Set endpoints = endpointHandlerMapping.getEndpoints();
            LinkedHashSet<String> paths = new LinkedHashSet<String>(endpoints.size());
            for (MvcEndpoint endpoint : endpoints) {
                if (!this.isIncluded(endpoint)) continue;
                String path = endpointHandlerMapping.getPath(endpoint.getPath());
                paths.add(path);
                if (!path.equals("")) {
                    paths.add(path + "/**");
                    paths.add(path + ".*");
                }
                paths.add(path + "/");
            }
            return paths.toArray(new String[paths.size()]);
        }

        protected boolean isIncluded(MvcEndpoint endpoint) {
            return true;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ManagementWebSecurityConfigurerAdapter.class})
    @ConditionalOnProperty(prefix="management.security", name={"enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={SecurityProperties.class})
    @Order(value=0x7FFFFFF5)
    protected static class ManagementWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private final SecurityProperties security;
        private final ManagementServerProperties management;
        private final ManagementContextResolver contextResolver;

        public ManagementWebSecurityConfigurerAdapter(SecurityProperties security, ManagementServerProperties management, ObjectProvider<ManagementContextResolver> contextResolver) {
            this.security = security;
            this.management = management;
            this.contextResolver = (ManagementContextResolver)contextResolver.getIfAvailable();
        }

        protected void configure(HttpSecurity http) throws Exception {
            RequestMatcher matcher = this.getRequestMatcher();
            if (matcher != null) {
                if (this.security.isRequireSsl()) {
                    ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
                }
                AuthenticationEntryPoint entryPoint = this.entryPoint();
                http.exceptionHandling().authenticationEntryPoint(entryPoint);
                http.requestMatcher(matcher);
                this.configurePermittedRequests(http.authorizeRequests());
                http.httpBasic().authenticationEntryPoint(entryPoint);
                http.csrf().disable();
                http.sessionManagement().sessionCreationPolicy(this.asSpringSecuritySessionCreationPolicy(this.management.getSecurity().getSessions()));
                SpringBootWebSecurityConfiguration.configureHeaders((HeadersConfigurer)http.headers(), (SecurityProperties.Headers)this.security.getHeaders());
            }
        }

        private SessionCreationPolicy asSpringSecuritySessionCreationPolicy(Enum<?> value) {
            if (value == null) {
                return SessionCreationPolicy.STATELESS;
            }
            return SessionCreationPolicy.valueOf((String)value.name());
        }

        private RequestMatcher getRequestMatcher() {
            if (this.management.getSecurity().isEnabled()) {
                return LazyEndpointPathRequestMatcher.getRequestMatcher(this.contextResolver);
            }
            return null;
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }

        private void configurePermittedRequests(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{new LazyEndpointPathRequestMatcher(this.contextResolver, EndpointPaths.SENSITIVE)})).authenticated();
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{new LazyEndpointPathRequestMatcher(this.contextResolver, EndpointPaths.NON_SENSITIVE)})).permitAll();
        }
    }

    static class WebSecurityEnablerCondition
    extends SpringBootCondition {
        WebSecurityEnablerCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String managementEnabled = context.getEnvironment().getProperty("management.security.enabled", "true");
            String basicEnabled = context.getEnvironment().getProperty("security.basic.enabled", "true");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"WebSecurityEnabled", (Object[])new Object[0]);
            if ("true".equalsIgnoreCase(managementEnabled) && !"true".equalsIgnoreCase(basicEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("security enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("security disabled"));
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
    @Conditional(value={WebSecurityEnablerCondition.class})
    @EnableWebSecurity
    protected static class WebSecurityEnabler
    extends AuthenticationManagerConfiguration {
        protected WebSecurityEnabler() {
        }
    }

    @Configuration
    protected static class ManagementSecurityPropertiesConfiguration
    implements SecurityPrerequisite {
        private final SecurityProperties securityProperties;
        private final ManagementServerProperties managementServerProperties;

        public ManagementSecurityPropertiesConfiguration(ObjectProvider<SecurityProperties> securityProperties, ObjectProvider<ManagementServerProperties> managementServerProperties) {
            this.securityProperties = (SecurityProperties)securityProperties.getIfAvailable();
            this.managementServerProperties = (ManagementServerProperties)managementServerProperties.getIfAvailable();
        }

        @PostConstruct
        public void init() {
            if (this.managementServerProperties != null && this.securityProperties != null) {
                this.securityProperties.getUser().getRole().addAll(this.managementServerProperties.getSecurity().getRoles());
            }
        }
    }

    private class ManagementIgnoredRequestCustomizer
    implements IgnoredRequestCustomizer {
        private final ManagementServerProperties management;
        private final ManagementContextResolver contextResolver;

        ManagementIgnoredRequestCustomizer(ManagementServerProperties management, ManagementContextResolver contextResolver) {
            this.management = management;
            this.contextResolver = contextResolver;
        }

        public void customize(WebSecurity.IgnoredRequestConfigurer configurer) {
            if (!this.management.getSecurity().isEnabled()) {
                RequestMatcher requestMatcher = LazyEndpointPathRequestMatcher.getRequestMatcher(this.contextResolver);
                configurer.requestMatchers(new RequestMatcher[]{requestMatcher});
            }
        }
    }
}

