/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.logging.LogLevel;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.util.StringUtils;

public class LoggersEndpointMBean
extends EndpointMBean {
    public LoggersEndpointMBean(String beanName, Endpoint<?> endpoint, ObjectMapper objectMapper) {
        super(beanName, endpoint, objectMapper);
    }

    @ManagedAttribute(description="Get log levels for all known loggers")
    public Object getLoggers() {
        return this.convert(this.getEndpoint().invoke());
    }

    @ManagedOperation(description="Get log level for a given logger")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="loggerName", description="Name of the logger")})
    public Object getLogger(String loggerName) {
        return this.convert(this.getEndpoint().invoke(loggerName));
    }

    @ManagedOperation(description="Set log level for a given logger")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="loggerName", description="Name of the logger"), @ManagedOperationParameter(name="logLevel", description="New log level (can be null or empty String to remove the custom level)")})
    public void setLogLevel(String loggerName, String logLevel) {
        this.getEndpoint().setLogLevel(loggerName, this.determineLogLevel(logLevel));
    }

    private LogLevel determineLogLevel(String logLevel) {
        if (StringUtils.hasText((String)logLevel)) {
            return LogLevel.valueOf((String)logLevel.toUpperCase());
        }
        return null;
    }

    public LoggersEndpoint getEndpoint() {
        return (LoggersEndpoint)super.getEndpoint();
    }
}

