/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.util.Assert;

public class CassandraHealthIndicator
extends AbstractHealthIndicator {
    private CassandraOperations cassandraOperations;

    public CassandraHealthIndicator(CassandraOperations cassandraOperations) {
        Assert.notNull((Object)cassandraOperations, (String)"CassandraOperations must not be null");
        this.cassandraOperations = cassandraOperations;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            Select select = QueryBuilder.select((String[])new String[]{"release_version"}).from("system", "local");
            ResultSet results = this.cassandraOperations.getCqlOperations().queryForResultSet((Statement)select);
            if (results.isExhausted()) {
                builder.up();
                return;
            }
            String version = results.one().getString(0);
            builder.up().withDetail("version", version);
        }
        catch (Exception ex) {
            builder.down(ex);
        }
    }
}

