/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.integration.support.management.Statistics;

public class SpringIntegrationMetricReader
implements MetricReader {
    private final IntegrationManagementConfigurer configurer;

    public SpringIntegrationMetricReader(IntegrationManagementConfigurer configurer) {
        this.configurer = configurer;
    }

    @Override
    public Metric<?> findOne(String metricName) {
        return null;
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        ArrayList result = new ArrayList();
        String[] channelNames = this.configurer.getChannelNames();
        String[] handlerNames = this.configurer.getHandlerNames();
        String[] sourceNames = this.configurer.getSourceNames();
        this.addChannelMetrics(result, channelNames);
        this.addHandlerMetrics(result, handlerNames);
        this.addSourceMetrics(result, sourceNames);
        result.add(new Metric<Integer>("integration.handlerCount", handlerNames.length));
        result.add(new Metric<Integer>("integration.channelCount", channelNames.length));
        result.add(new Metric<Integer>("integration.sourceCount", sourceNames.length));
        return result;
    }

    private void addChannelMetrics(List<Metric<?>> result, String[] names) {
        for (String name : names) {
            this.addChannelMetrics(result, name, this.configurer.getChannelMetrics(name));
        }
    }

    private void addChannelMetrics(List<Metric<?>> result, String name, MessageChannelMetrics metrics) {
        String prefix = "integration.channel." + name;
        result.addAll(this.getStatistics(prefix + ".errorRate", metrics.getErrorRate()));
        result.add(new Metric<Long>(prefix + ".sendCount", metrics.getSendCountLong()));
        result.addAll(this.getStatistics(prefix + ".sendRate", metrics.getSendRate()));
        if (metrics instanceof PollableChannelManagement) {
            result.add(new Metric<Long>(prefix + ".receiveCount", ((PollableChannelManagement)metrics).getReceiveCountLong()));
        }
    }

    private void addHandlerMetrics(List<Metric<?>> result, String[] names) {
        for (String name : names) {
            this.addHandlerMetrics(result, name, this.configurer.getHandlerMetrics(name));
        }
    }

    private void addHandlerMetrics(List<Metric<?>> result, String name, MessageHandlerMetrics metrics) {
        String prefix = "integration.handler." + name;
        result.addAll(this.getStatistics(prefix + ".duration", metrics.getDuration()));
        long activeCount = metrics.getActiveCountLong();
        result.add(new Metric<Long>(prefix + ".activeCount", activeCount));
    }

    private void addSourceMetrics(List<Metric<?>> result, String[] names) {
        for (String name : names) {
            this.addSourceMetrics(result, name, this.configurer.getSourceMetrics(name));
        }
    }

    private void addSourceMetrics(List<Metric<?>> result, String name, MessageSourceMetrics sourceMetrics) {
        String prefix = "integration.source." + name;
        result.add(new Metric<Long>(prefix + ".messageCount", sourceMetrics.getMessageCountLong()));
    }

    private Collection<? extends Metric<?>> getStatistics(String name, Statistics stats) {
        ArrayList<Metric<Number>> metrics = new ArrayList<Metric<Number>>();
        metrics.add(new Metric<Double>(name + ".mean", stats.getMean()));
        metrics.add(new Metric<Double>(name + ".max", stats.getMax()));
        metrics.add(new Metric<Double>(name + ".min", stats.getMin()));
        metrics.add(new Metric<Double>(name + ".stdev", stats.getStandardDeviation()));
        metrics.add(new Metric<Long>(name + ".count", stats.getCountLong()));
        return metrics;
    }

    @Override
    public long count() {
        int totalChannelCount = this.configurer.getChannelNames().length;
        int totalHandlerCount = this.configurer.getHandlerNames().length;
        int totalSourceCount = this.configurer.getSourceNames().length;
        return totalChannelCount + totalHandlerCount + totalSourceCount;
    }
}

