/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.condition;

import java.util.Map;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean enabledByDefault;
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnEnabledEndpoint.class.getName()));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.determineEndpointOutcome(endpointName, enabledByDefault = annotationAttributes.getBoolean("enabledByDefault"), context);
        if (outcome != null) {
            return outcome;
        }
        return this.determineAllEndpointsOutcome(context);
    }

    private ConditionOutcome determineEndpointOutcome(String endpointName, boolean enabledByDefault, ConditionContext context) {
        String enabledProperty;
        Environment environment = context.getEnvironment();
        if (environment.containsProperty(enabledProperty = "endpoints." + endpointName + ".enabled") || !enabledByDefault) {
            boolean match = (Boolean)environment.getProperty(enabledProperty, Boolean.class, (Object)enabledByDefault);
            ConditionMessage message = ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[]{"(" + endpointName + ")"}).because(match ? "enabled" : "disabled");
            return new ConditionOutcome(match, message);
        }
        return null;
    }

    private ConditionOutcome determineAllEndpointsOutcome(ConditionContext context) {
        boolean match = Boolean.valueOf(context.getEnvironment().getProperty("endpoints.enabled", "true"));
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("All endpoints are " + (match ? "enabled" : "disabled") + " by default");
        return new ConditionOutcome(match, message);
    }
}

