/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public abstract class AbstractMvcEndpoint
implements MvcEndpoint,
WebMvcConfigurer,
EnvironmentAware {
    private Environment environment;
    private String path;
    private Boolean enabled;
    private Boolean sensitive;
    private final boolean sensitiveDefault;

    public AbstractMvcEndpoint(String path, boolean sensitive) {
        this.setPath(path);
        this.sensitiveDefault = sensitive;
    }

    public AbstractMvcEndpoint(String path, boolean sensitive, boolean enabled) {
        this.setPath(path);
        this.sensitiveDefault = sensitive;
        this.enabled = enabled;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        Assert.isTrue((path.isEmpty() || path.startsWith("/") ? 1 : 0) != 0, (String)"Path must start with / or be empty");
        this.path = path;
    }

    public boolean isEnabled() {
        return EndpointProperties.isEnabled(this.environment, this.enabled);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, this.sensitiveDefault);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }
}

