/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.boot.actuate.metrics.buffer.Buffer;

abstract class Buffers<B extends Buffer<?>> {
    private final ConcurrentHashMap<String, B> buffers = new ConcurrentHashMap();

    Buffers() {
    }

    public void forEach(Predicate<String> predicate, BiConsumer<String, B> consumer) {
        this.buffers.forEach((name, value) -> {
            if (predicate.test((String)name)) {
                consumer.accept((String)name, (Object)value);
            }
        });
    }

    public B find(String name) {
        return (B)((Buffer)this.buffers.get(name));
    }

    public int count() {
        return this.buffers.size();
    }

    protected final void doWith(String name, Consumer<B> consumer) {
        Buffer buffer = (Buffer)this.buffers.get(name);
        if (buffer == null) {
            buffer = this.buffers.computeIfAbsent(name, k -> this.createBuffer());
        }
        consumer.accept(buffer);
    }

    protected abstract B createBuffer();
}

