/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import org.springframework.boot.actuate.metrics.buffer.Buffers;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffer;

public class CounterBuffers
extends Buffers<CounterBuffer> {
    public void increment(String name, long delta) {
        this.doWith(name, buffer -> {
            buffer.setTimestamp(System.currentTimeMillis());
            buffer.add(delta);
        });
    }

    public void reset(String name) {
        this.doWith(name, buffer -> {
            buffer.setTimestamp(System.currentTimeMillis());
            buffer.reset();
        });
    }

    @Override
    protected CounterBuffer createBuffer() {
        return new CounterBuffer(0L);
    }
}

