/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.util;

import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class SimpleInMemoryRepository<T> {
    private ConcurrentNavigableMap<String, T> values = new ConcurrentSkipListMap<String, T>();
    private final ConcurrentMap<String, Object> locks = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(String name, Callback<T> callback) {
        Object lock;
        Object object = lock = this.getLock(name);
        synchronized (object) {
            Object current = this.values.get(name);
            T value = callback.modify(current);
            this.values.put(name, value);
            return value;
        }
    }

    private Object getLock(String name) {
        Object newLock;
        Object lock = this.locks.get(name);
        if (lock == null && (lock = this.locks.putIfAbsent(name, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    public void set(String name, T value) {
        this.values.put(name, value);
    }

    public long count() {
        return this.values.size();
    }

    public void remove(String name) {
        this.values.remove(name);
    }

    public T findOne(String name) {
        return (T)this.values.get(name);
    }

    public Iterable<T> findAll() {
        return new ArrayList(this.values.values());
    }

    public Iterable<T> findAllWithPrefix(String prefix) {
        if (prefix.endsWith(".*")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return new ArrayList(this.values.subMap((Object)prefix, false, (Object)(prefix + "~"), true).values());
    }

    public void setValues(ConcurrentNavigableMap<String, T> values) {
        this.values = values;
    }

    protected NavigableMap<String, T> getValues() {
        return this.values;
    }

    @FunctionalInterface
    public static interface Callback<T> {
        public T modify(T var1);
    }
}

