/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanInfo;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;

class EndpointMBeanInfoAssembler {
    private final JmxOperationResponseMapper responseMapper;

    EndpointMBeanInfoAssembler(JmxOperationResponseMapper responseMapper) {
        this.responseMapper = responseMapper;
    }

    EndpointMBeanInfo createEndpointMBeanInfo(EndpointInfo<JmxEndpointOperation> endpointInfo) {
        Map<String, OperationInfos> operationsMapping = this.getOperationInfo(endpointInfo);
        ModelMBeanOperationInfo[] operationsMBeanInfo = operationsMapping.values().stream().map(t -> ((OperationInfos)t).mBeanOperationInfo).collect(Collectors.toList()).toArray(new ModelMBeanOperationInfo[0]);
        LinkedHashMap<String, JmxEndpointOperation> operationsInfo = new LinkedHashMap<String, JmxEndpointOperation>();
        operationsMapping.forEach((name, t) -> operationsInfo.put((String)name, ((OperationInfos)t).operation));
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(EndpointMBean.class.getName(), this.getDescription(endpointInfo), new ModelMBeanAttributeInfo[0], new ModelMBeanConstructorInfo[0], operationsMBeanInfo, new ModelMBeanNotificationInfo[0]);
        return new EndpointMBeanInfo(endpointInfo.getId(), info, operationsInfo);
    }

    private String getDescription(EndpointInfo<?> endpointInfo) {
        return "MBean operations for endpoint " + endpointInfo.getId();
    }

    private Map<String, OperationInfos> getOperationInfo(EndpointInfo<JmxEndpointOperation> endpointInfo) {
        HashMap<String, OperationInfos> operationInfos = new HashMap<String, OperationInfos>();
        endpointInfo.getOperations().forEach(operationInfo -> {
            String name = operationInfo.getOperationName();
            ModelMBeanOperationInfo mBeanOperationInfo = new ModelMBeanOperationInfo(operationInfo.getOperationName(), operationInfo.getDescription(), this.getMBeanParameterInfos((JmxEndpointOperation)operationInfo), this.responseMapper.mapResponseType(operationInfo.getOutputType()).getName(), this.mapOperationType(operationInfo.getType()));
            operationInfos.put(name, new OperationInfos(mBeanOperationInfo, (JmxEndpointOperation)operationInfo));
        });
        return operationInfos;
    }

    private MBeanParameterInfo[] getMBeanParameterInfos(JmxEndpointOperation operation) {
        return operation.getParameters().stream().map(operationParameter -> new MBeanParameterInfo(operationParameter.getName(), operationParameter.getType().getName(), operationParameter.getDescription())).collect(Collectors.collectingAndThen(Collectors.toList(), parameterInfos -> parameterInfos.toArray(new MBeanParameterInfo[parameterInfos.size()])));
    }

    private int mapOperationType(OperationType type) {
        if (type == OperationType.READ) {
            return 0;
        }
        if (type == OperationType.WRITE || type == OperationType.DELETE) {
            return 1;
        }
        return 3;
    }

    private static class OperationInfos {
        private final ModelMBeanOperationInfo mBeanOperationInfo;
        private final JmxEndpointOperation operation;

        OperationInfos(ModelMBeanOperationInfo mBeanOperationInfo, JmxEndpointOperation operation) {
            this.mBeanOperationInfo = mBeanOperationInfo;
            this.operation = operation;
        }
    }
}

