/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationParameterMapper;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.ReflectiveOperationInvoker;
import org.springframework.boot.actuate.endpoint.annotation.AnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.cache.CachingOperationInvoker;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperationParameterInfo;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.util.StringUtils;

public class JmxAnnotationEndpointDiscoverer
extends AnnotationEndpointDiscoverer<JmxEndpointOperation, String> {
    private static final AnnotationJmxAttributeSource jmxAttributeSource = new AnnotationJmxAttributeSource();

    public JmxAnnotationEndpointDiscoverer(ApplicationContext applicationContext, OperationParameterMapper parameterMapper, CachingConfigurationFactory cachingConfigurationFactory) {
        super(applicationContext, new JmxEndpointOperationFactory(parameterMapper), JmxEndpointOperation::getOperationName, cachingConfigurationFactory);
    }

    @Override
    public Collection<EndpointInfo<JmxEndpointOperation>> discoverEndpoints() {
        Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<JmxEndpointOperation, String>> endpointDescriptors = this.discoverEndpoints(JmxEndpointExtension.class, EndpointExposure.JMX);
        this.verifyThatOperationsHaveDistinctName(endpointDescriptors);
        return endpointDescriptors.stream().map(AnnotationEndpointDiscoverer.EndpointInfoDescriptor::getEndpointInfo).collect(Collectors.toList());
    }

    private void verifyThatOperationsHaveDistinctName(Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<JmxEndpointOperation, String>> endpointDescriptors) {
        ArrayList clashes = new ArrayList();
        endpointDescriptors.forEach(descriptor -> clashes.addAll(descriptor.findDuplicateOperations().values()));
        if (!clashes.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Found multiple JMX operations with the same name:%n", new Object[0]));
            clashes.forEach(clash -> {
                message.append("    ").append(((JmxEndpointOperation)clash.get(0)).getOperationName()).append(String.format(":%n", new Object[0]));
                clash.forEach(operation -> message.append("        ").append(String.format("%s%n", operation)));
            });
            throw new IllegalStateException(message.toString());
        }
    }

    private static class JmxEndpointOperationFactory
    implements AnnotationEndpointDiscoverer.EndpointOperationFactory<JmxEndpointOperation> {
        private final OperationParameterMapper parameterMapper;

        JmxEndpointOperationFactory(OperationParameterMapper parameterMapper) {
            this.parameterMapper = parameterMapper;
        }

        @Override
        public JmxEndpointOperation createOperation(String endpointId, AnnotationAttributes operationAttributes, Object target, Method method, OperationType type, long timeToLive) {
            String operationName = method.getName();
            Class<?> outputType = this.mapParameterType(method.getReturnType());
            String description = this.getDescription(method, () -> "Invoke " + operationName + " for endpoint " + endpointId);
            List<JmxEndpointOperationParameterInfo> parameters = this.getParameters(method);
            OperationInvoker invoker = new ReflectiveOperationInvoker(this.parameterMapper, target, method);
            if (timeToLive > 0L) {
                invoker = new CachingOperationInvoker(invoker, timeToLive);
            }
            return new JmxEndpointOperation(type, invoker, operationName, outputType, description, parameters);
        }

        private String getDescription(Method method, Supplier<String> fallback) {
            ManagedOperation managedOperation = jmxAttributeSource.getManagedOperation(method);
            if (managedOperation != null && StringUtils.hasText((String)managedOperation.getDescription())) {
                return managedOperation.getDescription();
            }
            return fallback.get();
        }

        private List<JmxEndpointOperationParameterInfo> getParameters(Method method) {
            Parameter[] methodParameters = method.getParameters();
            if (methodParameters.length == 0) {
                return Collections.emptyList();
            }
            ManagedOperationParameter[] managedOperationParameters = jmxAttributeSource.getManagedOperationParameters(method);
            if (managedOperationParameters.length == 0) {
                return this.getParametersInfo(methodParameters);
            }
            return this.getParametersInfo(methodParameters, managedOperationParameters);
        }

        private List<JmxEndpointOperationParameterInfo> getParametersInfo(Parameter[] methodParameters) {
            ArrayList<JmxEndpointOperationParameterInfo> parameters = new ArrayList<JmxEndpointOperationParameterInfo>();
            for (Parameter methodParameter : methodParameters) {
                String name = methodParameter.getName();
                Class<?> type = this.mapParameterType(methodParameter.getType());
                parameters.add(new JmxEndpointOperationParameterInfo(name, type, null));
            }
            return parameters;
        }

        private List<JmxEndpointOperationParameterInfo> getParametersInfo(Parameter[] methodParameters, ManagedOperationParameter[] managedOperationParameters) {
            ArrayList<JmxEndpointOperationParameterInfo> parameters = new ArrayList<JmxEndpointOperationParameterInfo>();
            for (int i = 0; i < managedOperationParameters.length; ++i) {
                ManagedOperationParameter managedOperationParameter = managedOperationParameters[i];
                Parameter methodParameter = methodParameters[i];
                parameters.add(new JmxEndpointOperationParameterInfo(managedOperationParameter.getName(), this.mapParameterType(methodParameter.getType()), managedOperationParameter.getDescription()));
            }
            return parameters;
        }

        private Class<?> mapParameterType(Class<?> parameter) {
            if (parameter.isEnum()) {
                return String.class;
            }
            if (Date.class.isAssignableFrom(parameter)) {
                return String.class;
            }
            if (parameter.getName().startsWith("java.")) {
                return parameter;
            }
            if (parameter.equals(Void.TYPE)) {
                return parameter;
            }
            return Object.class;
        }
    }
}

