/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="prometheus", exposure={EndpointExposure.WEB})
public class PrometheusScrapeEndpoint {
    private final CollectorRegistry collectorRegistry;

    public PrometheusScrapeEndpoint(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @ReadOperation(produces={"text/plain; version=0.0.4; charset=utf-8"})
    public String scrape() {
        try {
            StringWriter writer = new StringWriter();
            TextFormat.write004((Writer)writer, (Enumeration)this.collectorRegistry.metricFamilySamples());
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing metrics failed", e);
        }
    }
}

