/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private static final ParameterNameDiscoverer DEFAULT_PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Object target;
    private final Method method;
    private final ParameterMapper parameterMapper;
    private final ParameterNameDiscoverer parameterNameDiscoverer;

    public ReflectiveOperationInvoker(Object target, Method method, ParameterMapper parameterMapper) {
        this(target, method, parameterMapper, DEFAULT_PARAMETER_NAME_DISCOVERER);
    }

    public ReflectiveOperationInvoker(Object target, Method method, ParameterMapper parameterMapper, ParameterNameDiscoverer parameterNameDiscoverer) {
        Assert.notNull((Object)target, (String)"Target must not be null");
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)parameterMapper, (String)"ParameterMapper must not be null");
        Assert.notNull((Object)parameterNameDiscoverer, (String)"ParameterNameDiscoverer must not be null");
        ReflectionUtils.makeAccessible((Method)method);
        this.target = target;
        this.method = method;
        this.parameterMapper = parameterMapper;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public Method getMethod() {
        return this.method;
    }

    public <T> List<T> getParameters(BiFunction<String, Parameter, T> mapper) {
        return this.getParameters().entrySet().stream().map(entry -> mapper.apply((String)entry.getKey(), (Parameter)entry.getValue())).collect(Collectors.toCollection(ArrayList::new));
    }

    private Map<String, Parameter> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        String[] names = this.parameterNameDiscoverer.getParameterNames(this.method);
        Assert.state((names != null ? 1 : 0) != 0, (String)("Failed to extract parameter names for " + this.method));
        LinkedHashMap<String, Parameter> result = new LinkedHashMap<String, Parameter>();
        for (int i = 0; i < names.length; ++i) {
            result.put(names[i], parameters[i]);
        }
        return result;
    }

    @Override
    public Object invoke(Map<String, Object> arguments) {
        Map<String, Parameter> parameters = this.getParameters();
        this.validateRequiredParameters(parameters, arguments);
        return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])this.resolveArguments(parameters, arguments));
    }

    private void validateRequiredParameters(Map<String, Parameter> parameters, Map<String, Object> arguments) {
        Set<String> missingParameters = parameters.keySet().stream().filter(n -> this.isMissing((String)n, (Parameter)parameters.get(n), arguments)).collect(Collectors.toSet());
        if (!missingParameters.isEmpty()) {
            throw new ParametersMissingException(missingParameters);
        }
    }

    private boolean isMissing(String name, Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(name);
        return resolved == null && !this.isExplicitNullable(parameter);
    }

    private boolean isExplicitNullable(Parameter parameter) {
        return ((Nullable[])parameter.getAnnotationsByType(Nullable.class)).length != 0;
    }

    private Object[] resolveArguments(Map<String, Parameter> parameters, Map<String, Object> arguments) {
        return parameters.keySet().stream().map(name -> this.resolveArgument((String)name, (Parameter)parameters.get(name), arguments)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.toArray(new Object[list.size()])));
    }

    private Object resolveArgument(String name, Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(name);
        return this.parameterMapper.mapParameter(resolved, parameter.getType());
    }
}

