/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.DefaultEnablement;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.cache.CachingConfiguration;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ObjectUtils;

public abstract class AnnotationEndpointDiscoverer<T extends Operation, K>
implements EndpointDiscoverer<T> {
    private final ApplicationContext applicationContext;
    private final EndpointOperationFactory<T> operationFactory;
    private final Function<T, K> operationKeyFactory;
    private final CachingConfigurationFactory cachingConfigurationFactory;

    protected AnnotationEndpointDiscoverer(ApplicationContext applicationContext, EndpointOperationFactory<T> operationFactory, Function<T, K> operationKeyFactory, CachingConfigurationFactory cachingConfigurationFactory) {
        this.applicationContext = applicationContext;
        this.operationFactory = operationFactory;
        this.operationKeyFactory = operationKeyFactory;
        this.cachingConfigurationFactory = cachingConfigurationFactory;
    }

    protected Collection<EndpointInfoDescriptor<T, K>> discoverEndpoints(Class<? extends Annotation> extensionType, EndpointExposure exposure) {
        Map<Class<?>, EndpointInfo<T>> endpoints = this.discoverEndpoints(exposure);
        Map<Class<?>, EndpointExtensionInfo<T>> extensions = this.discoverExtensions(endpoints, extensionType, exposure);
        ArrayList<EndpointInfoDescriptor<T, K>> result = new ArrayList<EndpointInfoDescriptor<T, K>>();
        endpoints.forEach((endpointClass, endpointInfo) -> {
            EndpointExtensionInfo extension = (EndpointExtensionInfo)extensions.remove(endpointClass);
            result.add(this.createDescriptor((Class<?>)endpointClass, (EndpointInfo<T>)endpointInfo, extension));
        });
        return result;
    }

    private Map<Class<?>, EndpointInfo<T>> discoverEndpoints(EndpointExposure exposure) {
        String[] beanNames = BeanFactoryUtils.beanNamesForAnnotationIncludingAncestors((ListableBeanFactory)this.applicationContext, Endpoint.class);
        LinkedHashMap endpoints = new LinkedHashMap();
        LinkedHashMap<String, EndpointInfo<T>> endpointsById = new LinkedHashMap<String, EndpointInfo<T>>();
        for (String beanName : beanNames) {
            Class beanType = this.applicationContext.getType(beanName);
            AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement)beanType, Endpoint.class, (boolean)true, (boolean)true);
            if (!this.isExposedOver(attributes, exposure)) continue;
            EndpointInfo info = this.createEndpointInfo(beanName, beanType, attributes);
            EndpointInfo previous = endpointsById.putIfAbsent(info.getId(), info);
            Assert.state((previous == null ? 1 : 0) != 0, () -> "Found two endpoints with the id '" + info.getId() + "': " + info + " and " + previous);
            endpoints.put(beanType, info);
        }
        return endpoints;
    }

    private EndpointInfo<T> createEndpointInfo(String beanName, Class<?> beanType, AnnotationAttributes attributes) {
        String id = attributes.getString("id");
        DefaultEnablement defaultEnablement = (DefaultEnablement)((Object)attributes.get((Object)"defaultEnablement"));
        Map<Method, T> operations = this.discoverOperations(id, beanName, beanType);
        return new EndpointInfo<T>(id, defaultEnablement, operations.values());
    }

    private Map<Class<?>, EndpointExtensionInfo<T>> discoverExtensions(Map<Class<?>, EndpointInfo<T>> endpoints, Class<? extends Annotation> extensionType, EndpointExposure exposure) {
        if (extensionType == null) {
            return Collections.emptyMap();
        }
        String[] beanNames = BeanFactoryUtils.beanNamesForAnnotationIncludingAncestors((ListableBeanFactory)this.applicationContext, extensionType);
        HashMap extensions = new HashMap();
        for (String beanName : beanNames) {
            Class beanType = this.applicationContext.getType(beanName);
            Class<?> endpointType = this.getEndpointType(extensionType, beanType);
            AnnotationAttributes endpointAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes(endpointType, Endpoint.class);
            Assert.state((boolean)this.isExposedOver(endpointAttributes, exposure), () -> "Invalid extension " + beanType.getName() + "': endpoint '" + endpointType.getName() + "' does not support such extension");
            EndpointInfo<T> info = this.getEndpointInfo(endpoints, beanType, endpointType);
            Map<Method, T> operations = this.discoverOperations(info.getId(), beanName, beanType);
            EndpointExtensionInfo extension = new EndpointExtensionInfo(beanType, operations.values());
            EndpointExtensionInfo previous = extensions.putIfAbsent(endpointType, extension);
            Assert.state((previous == null ? 1 : 0) != 0, () -> "Found two extensions for the same endpoint '" + endpointType.getName() + "': " + extension.getExtensionType().getName() + " and " + previous.getExtensionType().getName());
        }
        return extensions;
    }

    private EndpointInfo<T> getEndpointInfo(Map<Class<?>, EndpointInfo<T>> endpoints, Class<?> beanType, Class<?> endpointClass) {
        EndpointInfo<T> endpoint = endpoints.get(endpointClass);
        Assert.state((endpoint != null ? 1 : 0) != 0, () -> "Invalid extension '" + beanType.getName() + "': no endpoint found with type '" + endpointClass.getName() + "'");
        return endpoint;
    }

    private Class<?> getEndpointType(Class<? extends Annotation> extensionType, Class<?> beanType) {
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(beanType, extensionType);
        return (Class)attributes.get((Object)"endpoint");
    }

    private EndpointInfoDescriptor<T, K> createDescriptor(Class<?> type, EndpointInfo<T> info, EndpointExtensionInfo<T> extension) {
        Map<OperationKey<OperationKey<K>>, List<T>> operations = this.indexOperations(info.getId(), type, info.getOperations());
        if (extension != null) {
            operations.putAll(this.indexOperations(info.getId(), ((EndpointExtensionInfo)extension).getExtensionType(), ((EndpointExtensionInfo)extension).getOperations()));
            return new EndpointInfoDescriptor<T, K>(this.mergeEndpoint(info, extension), operations);
        }
        return new EndpointInfoDescriptor<T, K>(info, operations);
    }

    private EndpointInfo<T> mergeEndpoint(EndpointInfo<T> endpoint, EndpointExtensionInfo<T> extension) {
        HashMap operations = new HashMap();
        Consumer<Operation> consumer = operation -> operations.put(this.operationKeyFactory.apply((Operation)operation), operation);
        endpoint.getOperations().forEach(consumer);
        ((EndpointExtensionInfo)extension).getOperations().forEach(consumer);
        return new EndpointInfo(endpoint.getId(), endpoint.getDefaultEnablement(), operations.values());
    }

    private Map<OperationKey<K>, List<T>> indexOperations(String endpointId, Class<?> target, Collection<T> operations) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        operations.forEach(operation -> {
            K key = this.operationKeyFactory.apply((Operation)operation);
            result.add(new OperationKey<K>(endpointId, target, key), operation);
        });
        return result;
    }

    private boolean isExposedOver(AnnotationAttributes attributes, EndpointExposure exposure) {
        if (exposure == null) {
            return true;
        }
        EndpointExposure[] supported = (EndpointExposure[])attributes.get((Object)"exposure");
        return ObjectUtils.isEmpty((Object[])supported) || ObjectUtils.containsElement((Object[])supported, (Object)((Object)exposure));
    }

    private Map<Method, T> discoverOperations(String id, String name, Class<?> type) {
        return MethodIntrospector.selectMethods(type, method -> this.createOperationIfPossible(id, name, method));
    }

    private T createOperationIfPossible(String endpointId, String beanName, Method method) {
        T operation = this.createReadOperationIfPossible(endpointId, beanName, method);
        if (operation != null) {
            return operation;
        }
        operation = this.createWriteOperationIfPossible(endpointId, beanName, method);
        if (operation != null) {
            return operation;
        }
        return this.createDeleteOperationIfPossible(endpointId, beanName, method);
    }

    private T createReadOperationIfPossible(String endpointId, String beanName, Method method) {
        return this.createOperationIfPossible(endpointId, beanName, method, ReadOperation.class, OperationType.READ);
    }

    private T createWriteOperationIfPossible(String endpointId, String beanName, Method method) {
        return this.createOperationIfPossible(endpointId, beanName, method, WriteOperation.class, OperationType.WRITE);
    }

    private T createDeleteOperationIfPossible(String endpointId, String beanName, Method method) {
        return this.createOperationIfPossible(endpointId, beanName, method, DeleteOperation.class, OperationType.DELETE);
    }

    private T createOperationIfPossible(String endpointId, String beanName, Method method, Class<? extends Annotation> operationAnnotation, OperationType operationType) {
        AnnotationAttributes operationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)method, operationAnnotation);
        if (operationAttributes == null) {
            return null;
        }
        CachingConfiguration cachingConfiguration = this.cachingConfigurationFactory.getCachingConfiguration(endpointId);
        return this.operationFactory.createOperation(endpointId, operationAttributes, this.applicationContext.getBean(beanName), method, operationType, this.determineTimeToLive(cachingConfiguration, operationType, method));
    }

    private long determineTimeToLive(CachingConfiguration cachingConfiguration, OperationType operationType, Method method) {
        if (cachingConfiguration != null && cachingConfiguration.getTimeToLive() > 0L && operationType == OperationType.READ && method.getParameters().length == 0) {
            return cachingConfiguration.getTimeToLive();
        }
        return 0L;
    }

    protected static final class OperationKey<K> {
        private final String endpointId;
        private final Class<?> endpointType;
        private final K key;

        public OperationKey(String endpointId, Class<?> endpointType, K key) {
            this.endpointId = endpointId;
            this.endpointType = endpointType;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationKey other = (OperationKey)o;
            Boolean result = true;
            result = result != false && this.endpointId.equals(other.endpointId);
            result = result != false && this.endpointType.equals(other.endpointType);
            result = result != false && this.key.equals(other.key);
            return result;
        }

        public int hashCode() {
            int result = this.endpointId.hashCode();
            result = 31 * result + this.endpointType.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }
    }

    protected static class EndpointInfoDescriptor<T extends Operation, K> {
        private final EndpointInfo<T> endpointInfo;
        private final Map<OperationKey<K>, List<T>> operations;

        protected EndpointInfoDescriptor(EndpointInfo<T> endpointInfo, Map<OperationKey<K>, List<T>> operations) {
            this.endpointInfo = endpointInfo;
            this.operations = operations;
        }

        public EndpointInfo<T> getEndpointInfo() {
            return this.endpointInfo;
        }

        public Map<OperationKey<K>, List<T>> findDuplicateOperations() {
            HashMap duplicateOperations = new HashMap();
            this.operations.forEach((k, list) -> {
                if (list.size() > 1) {
                    duplicateOperations.put((OperationKey)k, (List)list);
                }
            });
            return duplicateOperations;
        }
    }

    private static final class EndpointExtensionInfo<T extends Operation> {
        private final Class<?> extensionType;
        private final Collection<T> operations;

        private EndpointExtensionInfo(Class<?> extensionType, Collection<T> operations) {
            this.extensionType = extensionType;
            this.operations = operations;
        }

        private Class<?> getExtensionType() {
            return this.extensionType;
        }

        private Collection<T> getOperations() {
            return this.operations;
        }
    }

    @FunctionalInterface
    protected static interface EndpointOperationFactory<T extends Operation> {
        public T createOperation(String var1, AnnotationAttributes var2, Object var3, Method var4, OperationType var5, long var6);
    }
}

