/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.convert;

import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.convert.IsoOffsetDateTimeConverter;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;

public class ConversionServiceParameterMapper
implements ParameterMapper {
    private final ConversionService conversionService;

    public ConversionServiceParameterMapper() {
        this(ConversionServiceParameterMapper.createDefaultConversionService());
    }

    public ConversionServiceParameterMapper(ConversionService conversionService) {
        this.conversionService = new BinderConversionService(conversionService);
    }

    @Override
    public <T> T mapParameter(Object input, Class<T> parameterType) {
        try {
            return (T)this.conversionService.convert(input, parameterType);
        }
        catch (Exception ex) {
            throw new ParameterMappingException(input, parameterType, ex);
        }
    }

    private static ConversionService createDefaultConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        IsoOffsetDateTimeConverter.registerConverter((ConverterRegistry)conversionService);
        return conversionService;
    }
}

