/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.jmx.JmxException;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.util.Assert;

public class EndpointMBeanRegistrar {
    private static final Log logger = LogFactory.getLog(EndpointMBeanRegistrar.class);
    private final MBeanServer mBeanServer;
    private final EndpointObjectNameFactory objectNameFactory;

    public EndpointMBeanRegistrar(MBeanServer mBeanServer, EndpointObjectNameFactory objectNameFactory) {
        Assert.notNull((Object)mBeanServer, (String)"MBeanServer must not be null");
        Assert.notNull((Object)objectNameFactory, (String)"ObjectNameFactory must not be null");
        this.mBeanServer = mBeanServer;
        this.objectNameFactory = objectNameFactory;
    }

    public ObjectName registerEndpointMBean(EndpointMBean endpoint) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering endpoint with id '" + endpoint.getEndpointId() + "' to the JMX domain"));
            }
            ObjectName objectName = this.objectNameFactory.generate(endpoint);
            this.mBeanServer.registerMBean(endpoint, objectName);
            return objectName;
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException("Invalid ObjectName for endpoint with id '" + endpoint.getEndpointId() + "'", ex);
        }
        catch (Exception ex) {
            throw new MBeanExportException("Failed to register MBean for endpoint with id '" + endpoint.getEndpointId() + "'", (Throwable)ex);
        }
    }

    public boolean unregisterEndpointMbean(ObjectName objectName) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unregister endpoint with ObjectName '" + objectName + "' from the JMX domain"));
            }
            this.mBeanServer.unregisterMBean(objectName);
            return true;
        }
        catch (InstanceNotFoundException ex) {
            return false;
        }
        catch (MBeanRegistrationException ex) {
            throw new JmxException("Failed to unregister MBean with ObjectName '" + objectName + "'", (Throwable)ex);
        }
    }
}

