/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;

public class EndpointLinksResolver {
    public Map<String, Link> resolveLinks(Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, String requestUrl) {
        String normalizedUrl = this.normalizeRequestUrl(requestUrl);
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        links.put("self", new Link(normalizedUrl));
        for (EndpointInfo<WebEndpointOperation> endpoint : webEndpoints) {
            for (WebEndpointOperation operation : endpoint.getOperations()) {
                webEndpoints.stream().map(EndpointInfo::getId).forEach(id -> links.put(operation.getId(), this.createLink(normalizedUrl, operation)));
            }
        }
        return links;
    }

    private String normalizeRequestUrl(String requestUrl) {
        if (requestUrl.endsWith("/")) {
            return requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }

    private Link createLink(String requestUrl, WebEndpointOperation operation) {
        String path = operation.getRequestPredicate().getPath();
        return new Link(requestUrl + (path.startsWith("/") ? path : "/" + path));
    }
}

