/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.jersey;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.Resource;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class JerseyEndpointResourceFactory {
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();

    public Collection<Resource> createEndpointResources(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        webEndpoints.stream().flatMap(endpointInfo -> endpointInfo.getOperations().stream()).map(operation -> this.createResource(endpointMapping, (WebEndpointOperation)operation)).forEach(resources::add);
        if (StringUtils.hasText((String)endpointMapping.getPath())) {
            resources.add(this.createEndpointLinksResource(endpointMapping.getPath(), webEndpoints, endpointMediaTypes));
        }
        return resources;
    }

    private Resource createResource(EndpointMapping endpointMapping, WebEndpointOperation operation) {
        OperationRequestPredicate requestPredicate = operation.getRequestPredicate();
        Resource.Builder resourceBuilder = Resource.builder().path(endpointMapping.createSubPath(requestPredicate.getPath()));
        resourceBuilder.addMethod(requestPredicate.getHttpMethod().name()).consumes(this.toStringArray(requestPredicate.getConsumes())).produces(this.toStringArray(requestPredicate.getProduces())).handledBy((Inflector)new EndpointInvokingInflector(operation.getInvoker(), !requestPredicate.getConsumes().isEmpty()));
        return resourceBuilder.build();
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private Resource createEndpointLinksResource(String endpointPath, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes) {
        Resource.Builder resourceBuilder = Resource.builder().path(endpointPath);
        resourceBuilder.addMethod("GET").produces(endpointMediaTypes.getProduced().toArray(new String[endpointMediaTypes.getProduced().size()])).handledBy((Inflector)new EndpointLinksInflector(webEndpoints, this.endpointLinksResolver));
        return resourceBuilder.build();
    }

    private static final class EndpointLinksInflector
    implements Inflector<ContainerRequestContext, Response> {
        private final Collection<EndpointInfo<WebEndpointOperation>> endpoints;
        private final EndpointLinksResolver linksResolver;

        private EndpointLinksInflector(Collection<EndpointInfo<WebEndpointOperation>> endpoints, EndpointLinksResolver linksResolver) {
            this.endpoints = endpoints;
            this.linksResolver = linksResolver;
        }

        public Response apply(ContainerRequestContext request) {
            Map<String, Link> links = this.linksResolver.resolveLinks(this.endpoints, request.getUriInfo().getAbsolutePath().toString());
            return Response.ok(Collections.singletonMap("_links", links)).build();
        }
    }

    private static final class MonoBodyConverter
    implements Function<Object, Object> {
        private MonoBodyConverter() {
        }

        @Override
        public Object apply(Object body) {
            if (body instanceof Mono) {
                return ((Mono)body).block();
            }
            return body;
        }
    }

    private static final class ResourceBodyConverter
    implements Function<Object, Object> {
        private ResourceBodyConverter() {
        }

        @Override
        public Object apply(Object body) {
            if (body instanceof org.springframework.core.io.Resource) {
                try {
                    return ((org.springframework.core.io.Resource)body).getInputStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException();
                }
            }
            return body;
        }
    }

    private static final class EndpointInvokingInflector
    implements Inflector<ContainerRequestContext, Object> {
        private static final List<Function<Object, Object>> bodyConverters;
        private final OperationInvoker operationInvoker;
        private final boolean readBody;

        private EndpointInvokingInflector(OperationInvoker operationInvoker, boolean readBody) {
            this.operationInvoker = operationInvoker;
            this.readBody = readBody;
        }

        public Response apply(ContainerRequestContext data) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            if (this.readBody) {
                arguments.putAll(this.extractBodyArguments(data));
            }
            arguments.putAll(this.extractPathParameters(data));
            arguments.putAll(this.extractQueryParameters(data));
            try {
                Object response = this.operationInvoker.invoke(arguments);
                return this.convertToJaxRsResponse(response, data.getRequest().getMethod());
            }
            catch (ParameterMappingException | ParametersMissingException ex) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }

        private Map<String, Object> extractBodyArguments(ContainerRequestContext data) {
            Map entity = (Map)((ContainerRequest)data).readEntity(Map.class);
            if (entity == null) {
                return Collections.emptyMap();
            }
            return entity;
        }

        private Map<String, Object> extractPathParameters(ContainerRequestContext requestContext) {
            return this.extract((MultivaluedMap<String, String>)requestContext.getUriInfo().getPathParameters());
        }

        private Map<String, Object> extractQueryParameters(ContainerRequestContext requestContext) {
            return this.extract((MultivaluedMap<String, String>)requestContext.getUriInfo().getQueryParameters());
        }

        private Map<String, Object> extract(MultivaluedMap<String, String> multivaluedMap) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            multivaluedMap.forEach((name, values) -> {
                if (!CollectionUtils.isEmpty((Collection)values)) {
                    result.put((String)name, values.size() == 1 ? values.get(0) : values);
                }
            });
            return result;
        }

        private Response convertToJaxRsResponse(Object response, String httpMethod) {
            if (response == null) {
                boolean isGet = "GET".equals(httpMethod);
                Response.Status status = isGet ? Response.Status.NOT_FOUND : Response.Status.NO_CONTENT;
                return Response.status((Response.Status)status).build();
            }
            try {
                if (!(response instanceof WebEndpointResponse)) {
                    return Response.status((Response.Status)Response.Status.OK).entity(this.convertIfNecessary(response)).build();
                }
                WebEndpointResponse webEndpointResponse = (WebEndpointResponse)response;
                return Response.status((int)webEndpointResponse.getStatus()).entity(this.convertIfNecessary(webEndpointResponse.getBody())).build();
            }
            catch (IOException ex) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }

        private Object convertIfNecessary(Object body) throws IOException {
            for (Function<Object, Object> converter : bodyConverters) {
                body = converter.apply(body);
            }
            return body;
        }

        static {
            ArrayList<Function<Object, Object>> converters = new ArrayList<Function<Object, Object>>();
            converters.add(new ResourceBodyConverter());
            if (ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)EndpointInvokingInflector.class.getClassLoader())) {
                converters.add(new MonoBodyConverter());
            }
            bodyConverters = Collections.unmodifiableList(converters);
        }
    }
}

