/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.env;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointExtension;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;

@WebEndpointExtension(endpoint=EnvironmentEndpoint.class)
public class EnvironmentWebEndpointExtension {
    private final EnvironmentEndpoint delegate;

    public EnvironmentWebEndpointExtension(EnvironmentEndpoint delegate) {
        this.delegate = delegate;
    }

    @ReadOperation
    public WebEndpointResponse<EnvironmentEndpoint.EnvironmentEntryDescriptor> environmentEntry(@Selector String toMatch) {
        EnvironmentEndpoint.EnvironmentEntryDescriptor descriptor = this.delegate.environmentEntry(toMatch);
        return new WebEndpointResponse<EnvironmentEndpoint.EnvironmentEntryDescriptor>(descriptor, this.getStatus(descriptor));
    }

    private int getStatus(EnvironmentEndpoint.EnvironmentEntryDescriptor descriptor) {
        if (descriptor.getProperty() == null) {
            return 404;
        }
        return 200;
    }
}

