/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.flyway;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.util.Assert;

@Endpoint(id="flyway")
public class FlywayEndpoint {
    private final Map<String, Flyway> flywayBeans;

    public FlywayEndpoint(Map<String, Flyway> flywayBeans) {
        Assert.notEmpty(flywayBeans, (String)"FlywayBeans must be specified");
        this.flywayBeans = flywayBeans;
    }

    @ReadOperation
    public Map<String, FlywayReport> flywayReports() {
        HashMap<String, FlywayReport> reports = new HashMap<String, FlywayReport>();
        this.flywayBeans.forEach((name, flyway) -> reports.put((String)name, new FlywayReport(flyway.info().all())));
        return reports;
    }

    public static class FlywayMigration {
        private final MigrationType type;
        private final Integer checksum;
        private final String version;
        private final String description;
        private final String script;
        private final MigrationState state;
        private final String installedBy;
        private final Date installedOn;
        private final Integer installedRank;
        private final Integer executionTime;

        public FlywayMigration(MigrationInfo info) {
            this.type = info.getType();
            this.checksum = info.getChecksum();
            this.version = this.nullSafeToString(info.getVersion());
            this.description = info.getDescription();
            this.script = info.getScript();
            this.state = info.getState();
            this.installedBy = info.getInstalledBy();
            this.installedOn = info.getInstalledOn();
            this.installedRank = info.getInstalledRank();
            this.executionTime = info.getExecutionTime();
        }

        private String nullSafeToString(Object obj) {
            return obj == null ? null : obj.toString();
        }

        public MigrationType getType() {
            return this.type;
        }

        public Integer getChecksum() {
            return this.checksum;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public String getScript() {
            return this.script;
        }

        public MigrationState getState() {
            return this.state;
        }

        public String getInstalledBy() {
            return this.installedBy;
        }

        public Date getInstalledOn() {
            return this.installedOn;
        }

        public Integer getInstalledRank() {
            return this.installedRank;
        }

        public Integer getExecutionTime() {
            return this.executionTime;
        }
    }

    public static class FlywayReport {
        private final List<FlywayMigration> migrations;

        public FlywayReport(MigrationInfo[] migrations) {
            this.migrations = Stream.of(migrations).map(FlywayMigration::new).collect(Collectors.toList());
        }

        public FlywayReport(List<FlywayMigration> migrations) {
            this.migrations = migrations;
        }

        public List<FlywayMigration> getMigrations() {
            return this.migrations;
        }
    }
}

