/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import reactor.core.publisher.Mono;

@WebEndpointExtension(endpoint=HealthEndpoint.class)
public class HealthReactiveWebEndpointExtension {
    private final ReactiveHealthIndicator delegate;
    private final HealthStatusHttpMapper statusHttpMapper;

    public HealthReactiveWebEndpointExtension(ReactiveHealthIndicator delegate, HealthStatusHttpMapper statusHttpMapper) {
        this.delegate = delegate;
        this.statusHttpMapper = statusHttpMapper;
    }

    @ReadOperation
    public Mono<WebEndpointResponse<Health>> health() {
        return this.delegate.health().map(health -> {
            Integer status = this.statusHttpMapper.mapStatus(health.getStatus());
            return new WebEndpointResponse<Health>((Health)health, status);
        });
    }
}

