/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import io.micrometer.core.instrument.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

public final class WebMvcTags {
    private WebMvcTags() {
    }

    public static Tag method(HttpServletRequest request) {
        return Tag.of((String)"method", (String)request.getMethod());
    }

    public static Tag status(HttpServletResponse response) {
        return Tag.of((String)"status", (String)Integer.valueOf(response.getStatus()).toString());
    }

    public static Tag uri(HttpServletRequest request, HttpServletResponse response) {
        String uri;
        if (response != null) {
            HttpStatus status = HttpStatus.valueOf((int)response.getStatus());
            if (status.is3xxRedirection()) {
                return Tag.of((String)"uri", (String)"REDIRECTION");
            }
            if (status.equals((Object)HttpStatus.NOT_FOUND)) {
                return Tag.of((String)"uri", (String)"NOT_FOUND");
            }
        }
        if ((uri = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)) == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        return Tag.of((String)"uri", (String)(uri.isEmpty() ? "root" : uri));
    }

    public static Tag exception(Throwable exception) {
        if (exception != null) {
            return Tag.of((String)"exception", (String)exception.getClass().getSimpleName());
        }
        return Tag.of((String)"exception", (String)"None");
    }
}

