/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.actuate.endpoint.annotation.FilteredEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.OperationFactory;
import org.springframework.boot.actuate.endpoint.annotation.OperationsFactory;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public abstract class AnnotationEndpointDiscoverer<K, T extends Operation>
implements EndpointDiscoverer<T> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ApplicationContext applicationContext;
    private final Function<T, K> operationKeyFactory;
    private final OperationsFactory<T> operationsFactory;
    private final List<EndpointFilter<T>> filters;

    protected AnnotationEndpointDiscoverer(ApplicationContext applicationContext, OperationFactory<T> operationFactory, Function<T, K> operationKeyFactory, ParameterMapper parameterMapper, Collection<? extends OperationMethodInvokerAdvisor> invokerAdvisors, Collection<? extends EndpointFilter<T>> filters) {
        Assert.notNull((Object)applicationContext, (String)"Application Context must not be null");
        Assert.notNull(operationFactory, (String)"Operation Factory must not be null");
        Assert.notNull(operationKeyFactory, (String)"Operation Key Factory must not be null");
        Assert.notNull((Object)parameterMapper, (String)"Parameter Mapper must not be null");
        this.applicationContext = applicationContext;
        this.operationKeyFactory = operationKeyFactory;
        this.operationsFactory = new OperationsFactory<T>(operationFactory, parameterMapper, invokerAdvisors);
        this.filters = filters == null ? Collections.emptyList() : new ArrayList<EndpointFilter<T>>(filters);
    }

    @Override
    public final Collection<EndpointInfo<T>> discoverEndpoints() {
        Class<T> operationType = this.getOperationType();
        Map<Class<?>, DiscoveredEndpoint> endpoints = this.getEndpoints(operationType);
        Map<Class<?>, DiscoveredExtension> extensions = this.getExtensions(operationType, endpoints);
        Collection<DiscoveredEndpoint> exposed = this.mergeExposed(endpoints, extensions);
        this.verify(exposed);
        return exposed.stream().map(DiscoveredEndpoint::getInfo).collect(Collectors.toCollection(ArrayList::new));
    }

    protected Class<T> getOperationType() {
        return ResolvableType.forClass(AnnotationEndpointDiscoverer.class, this.getClass()).resolveGeneric(new int[]{1});
    }

    private Map<Class<?>, DiscoveredEndpoint> getEndpoints(Class<T> operationType) {
        String[] beanNames;
        LinkedHashMap endpoints = new LinkedHashMap();
        LinkedHashMap<String, DiscoveredEndpoint> endpointsById = new LinkedHashMap<String, DiscoveredEndpoint>();
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForAnnotationIncludingAncestors((ListableBeanFactory)this.applicationContext, Endpoint.class)) {
            this.addEndpoint(endpoints, endpointsById, beanName);
        }
        return endpoints;
    }

    private void addEndpoint(Map<Class<?>, DiscoveredEndpoint> endpoints, Map<String, DiscoveredEndpoint> endpointsById, String beanName) {
        Class endpointType = this.applicationContext.getType(beanName);
        Object target = this.applicationContext.getBean(beanName);
        DiscoveredEndpoint endpoint = this.createEndpoint(target, endpointType);
        String id = endpoint.getInfo().getId();
        DiscoveredEndpoint previous = endpointsById.putIfAbsent(id, endpoint);
        Assert.state((previous == null ? 1 : 0) != 0, () -> "Found two endpoints with the id '" + id + "': " + endpoint + " and " + previous);
        endpoints.put(endpointType, endpoint);
    }

    private DiscoveredEndpoint createEndpoint(Object target, Class<?> endpointType) {
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.findMergedAnnotationAttributes(endpointType, Endpoint.class, (boolean)true, (boolean)true);
        String id = annotationAttributes.getString("id");
        Assert.state((boolean)StringUtils.hasText((String)id), (String)("No @Endpoint id attribute specified for " + endpointType.getName()));
        boolean enabledByDefault = (Boolean)annotationAttributes.get((Object)"enableByDefault");
        Collection<T> operations = this.operationsFactory.createOperations(id, target, endpointType).values();
        EndpointInfo<T> endpointInfo = new EndpointInfo<T>(id, enabledByDefault, operations);
        boolean exposed = this.isEndpointExposed(endpointType, endpointInfo);
        return new DiscoveredEndpoint(endpointType, endpointInfo, exposed);
    }

    private Map<Class<?>, DiscoveredExtension> getExtensions(Class<T> operationType, Map<Class<?>, DiscoveredEndpoint> endpoints) {
        String[] beanNames;
        LinkedHashMap extensions = new LinkedHashMap();
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForAnnotationIncludingAncestors((ListableBeanFactory)this.applicationContext, EndpointExtension.class)) {
            this.addExtension(endpoints, extensions, beanName);
        }
        return extensions;
    }

    private void addExtension(Map<Class<?>, DiscoveredEndpoint> endpoints, Map<Class<?>, DiscoveredExtension> extensions, String beanName) {
        DiscoveredEndpoint endpoint;
        Class extensionType = this.applicationContext.getType(beanName);
        Class<?> endpointType = this.getEndpointType(extensionType);
        if (this.isExtensionExposed(endpointType, extensionType, (endpoint = this.getExtendingEndpoint(endpoints, extensionType, endpointType)).getInfo())) {
            Assert.state((endpoint.isExposed() || this.isEndpointFiltered(endpoint.getInfo()) ? 1 : 0) != 0, () -> "Invalid extension " + extensionType.getName() + "': endpoint '" + endpointType.getName() + "' does not support such extension");
            Object target = this.applicationContext.getBean(beanName);
            Map<Method, T> operations = this.operationsFactory.createOperations(endpoint.getInfo().getId(), target, extensionType);
            DiscoveredExtension extension = new DiscoveredExtension(extensionType, operations.values());
            DiscoveredExtension previous = extensions.putIfAbsent(endpointType, extension);
            Assert.state((previous == null ? 1 : 0) != 0, () -> "Found two extensions for the same endpoint '" + endpointType.getName() + "': " + extension.getExtensionType().getName() + " and " + previous.getExtensionType().getName());
        }
    }

    private Class<?> getEndpointType(Class<?> extensionType) {
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(extensionType, EndpointExtension.class);
        Class endpointType = attributes.getClass("endpoint");
        Assert.state((!endpointType.equals(Void.class) ? 1 : 0) != 0, () -> "Extension " + endpointType.getName() + " does not specify an endpoint");
        return endpointType;
    }

    private DiscoveredEndpoint getExtendingEndpoint(Map<Class<?>, DiscoveredEndpoint> endpoints, Class<?> extensionType, Class<?> endpointType) {
        DiscoveredEndpoint endpoint = endpoints.get(endpointType);
        Assert.state((endpoint != null ? 1 : 0) != 0, () -> "Invalid extension '" + extensionType.getName() + "': no endpoint found with type '" + endpointType.getName() + "'");
        return endpoint;
    }

    private boolean isEndpointExposed(Class<?> endpointType, EndpointInfo<T> endpointInfo) {
        if (this.isEndpointFiltered(endpointInfo)) {
            return false;
        }
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes(endpointType, FilteredEndpoint.class);
        if (annotationAttributes == null) {
            return true;
        }
        Class filterClass = annotationAttributes.getClass("value");
        return this.isFilterMatch(filterClass, endpointInfo);
    }

    private boolean isEndpointFiltered(EndpointInfo<T> endpointInfo) {
        for (EndpointFilter<T> filter : this.filters) {
            if (this.isFilterMatch(filter, endpointInfo)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExtensionExposed(Class<?> endpointType, Class<?> extensionType, EndpointInfo<T> endpointInfo) {
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes(extensionType, EndpointExtension.class);
        Class filterClass = annotationAttributes.getClass("filter");
        return this.isFilterMatch(filterClass, endpointInfo);
    }

    private boolean isFilterMatch(Class<?> filterClass, EndpointInfo<T> endpointInfo) {
        Class generic = ResolvableType.forClass(EndpointFilter.class, filterClass).resolveGeneric(new int[]{0});
        if (generic == null || generic.isAssignableFrom(this.getOperationType())) {
            EndpointFilter filter = (EndpointFilter)BeanUtils.instantiateClass(filterClass);
            return this.isFilterMatch(filter, endpointInfo);
        }
        return false;
    }

    private boolean isFilterMatch(EndpointFilter<T> filter, EndpointInfo<T> endpointInfo) {
        try {
            return filter.match(endpointInfo, this);
        }
        catch (ClassCastException ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.startsWith(endpointInfo.getClass().getName())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Non-matching info type for filter: " + filter), (Throwable)ex);
                }
                return false;
            }
            throw ex;
        }
    }

    private Collection<DiscoveredEndpoint> mergeExposed(Map<Class<?>, DiscoveredEndpoint> endpoints, Map<Class<?>, DiscoveredExtension> extensions) {
        ArrayList<DiscoveredEndpoint> result = new ArrayList<DiscoveredEndpoint>();
        endpoints.forEach((endpointClass, endpoint) -> {
            if (((DiscoveredEndpoint)endpoint).isExposed()) {
                DiscoveredExtension extension = (DiscoveredExtension)extensions.remove(endpointClass);
                result.add(((DiscoveredEndpoint)endpoint).merge(extension));
            }
        });
        return result;
    }

    protected void verify(Collection<DiscoveredEndpoint> exposedEndpoints) {
    }

    protected final class OperationKey {
        private final String endpointId;
        private final Class<?> target;
        private final K key;

        public OperationKey(String endpointId, Class<?> target, K key) {
            this.endpointId = endpointId;
            this.target = target;
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationKey other = (OperationKey)o;
            Boolean result = true;
            result = result != false && this.endpointId.equals(other.endpointId);
            result = result != false && this.target.equals(other.target);
            result = result != false && this.key.equals(other.key);
            return result;
        }

        public int hashCode() {
            int result = this.endpointId.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("endpointId", (Object)this.endpointId).append("target", this.target).append("key", this.key).toString();
        }
    }

    protected final class DiscoveredExtension {
        private final Class<?> extensionType;
        private final Collection<T> operations;

        private DiscoveredExtension(Class<?> extensionType, Collection<T> operations) {
            this.extensionType = extensionType;
            this.operations = operations;
        }

        public Class<?> getExtensionType() {
            return this.extensionType;
        }

        public Collection<T> getOperations() {
            return this.operations;
        }

        public String toString() {
            return this.extensionType.getName();
        }
    }

    protected final class DiscoveredEndpoint {
        private final EndpointInfo<T> info;
        private final boolean exposed;
        private final Map<OperationKey, List<T>> operations;

        private DiscoveredEndpoint(Class<?> type, EndpointInfo<T> info, boolean exposed) {
            Assert.notNull(info, (String)"Info must not be null");
            this.info = info;
            this.exposed = exposed;
            this.operations = this.indexEndpointOperations(type, info);
        }

        private Map<OperationKey, List<T>> indexEndpointOperations(Class<?> endpointType, EndpointInfo<T> info) {
            return Collections.unmodifiableMap(this.indexOperations(info.getId(), endpointType, info.getOperations()));
        }

        private DiscoveredEndpoint(EndpointInfo<T> info, boolean exposed, Map<OperationKey, List<T>> operations) {
            Assert.notNull(info, (String)"Info must not be null");
            this.info = info;
            this.exposed = exposed;
            this.operations = operations;
        }

        public EndpointInfo<T> getInfo() {
            return this.info;
        }

        private boolean isExposed() {
            return this.exposed;
        }

        public Map<OperationKey, List<T>> getOperations() {
            return this.operations;
        }

        public Map<OperationKey, List<T>> findDuplicateOperations() {
            return this.operations.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> v, LinkedHashMap::new));
        }

        private DiscoveredEndpoint merge(DiscoveredExtension extension) {
            if (extension == null) {
                return this;
            }
            Map operations = this.mergeOperations(extension);
            EndpointInfo info = new EndpointInfo(this.info.getId(), this.info.isEnableByDefault(), this.flatten(operations).values());
            return new DiscoveredEndpoint(info, this.exposed, operations);
        }

        private Map<OperationKey, List<T>> mergeOperations(DiscoveredExtension extension) {
            LinkedMultiValueMap operations = new LinkedMultiValueMap(this.operations);
            operations.addAll(this.indexOperations(this.getInfo().getId(), extension.getExtensionType(), extension.getOperations()));
            return Collections.unmodifiableMap(operations);
        }

        private Map<K, T> flatten(Map<OperationKey, List<T>> operations) {
            LinkedHashMap flattened = new LinkedHashMap();
            operations.forEach((operationKey, value) -> {
                Operation cfr_ignored_0 = (Operation)flattened.put(operationKey.getKey(), this.getLastValue((List)value));
            });
            return Collections.unmodifiableMap(flattened);
        }

        private T getLastValue(List<T> value) {
            return (Operation)value.get(value.size() - 1);
        }

        private MultiValueMap<OperationKey, T> indexOperations(String endpointId, Class<?> target, Collection<T> operations) {
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            operations.forEach(operation -> {
                Object key = this.getOperationKey(operation);
                result.add((Object)new OperationKey(endpointId, target, key), operation);
            });
            return result;
        }

        private K getOperationKey(T operation) {
            return AnnotationEndpointDiscoverer.this.operationKeyFactory.apply(operation);
        }

        public String toString() {
            return this.getInfo().toString();
        }
    }
}

