/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperationParameterInfo;
import org.springframework.core.style.ToStringCreator;

public class JmxOperation
extends Operation {
    private final String operationName;
    private final Class<?> outputType;
    private final String description;
    private final List<JmxEndpointOperationParameterInfo> parameters;

    public JmxOperation(OperationType type, OperationInvoker invoker, String operationName, Class<?> outputType, String description, List<JmxEndpointOperationParameterInfo> parameters) {
        super(type, invoker, true);
        this.operationName = operationName;
        this.outputType = outputType;
        this.description = description;
        this.parameters = parameters;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Class<?> getOutputType() {
        return this.outputType;
    }

    public String getDescription() {
        return this.description;
    }

    public List<JmxEndpointOperationParameterInfo> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("type", (Object)this.getType()).append("invoker", (Object)this.getInvoker()).append("blocking", this.isBlocking()).append("operationName", (Object)this.operationName).append("outputType", this.outputType).append("description", (Object)this.description).toString();
    }
}

