/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx.annotation;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.annotation.AnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperation;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointOperationFactory;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;

public class JmxAnnotationEndpointDiscoverer
extends AnnotationEndpointDiscoverer<String, JmxOperation> {
    static final AnnotationJmxAttributeSource jmxAttributeSource = new AnnotationJmxAttributeSource();

    public JmxAnnotationEndpointDiscoverer(ApplicationContext applicationContext, ParameterMapper parameterMapper, Collection<? extends OperationMethodInvokerAdvisor> invokerAdvisors, Collection<? extends EndpointFilter<JmxOperation>> filters) {
        super(applicationContext, new JmxEndpointOperationFactory(), JmxOperation::getOperationName, parameterMapper, invokerAdvisors, filters);
    }

    @Override
    protected void verify(Collection<AnnotationEndpointDiscoverer.DiscoveredEndpoint> exposedEndpoints) {
        ArrayList clashes = new ArrayList();
        exposedEndpoints.forEach(exposedEndpoint -> clashes.addAll(exposedEndpoint.findDuplicateOperations().values()));
        if (!clashes.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Found multiple JMX operations with the same name:%n", new Object[0]));
            clashes.forEach(clash -> {
                message.append("    ").append(((JmxOperation)clash.get(0)).getOperationName()).append(String.format(":%n", new Object[0]));
                clash.forEach(operation -> message.append("        ").append(String.format("%s%n", operation)));
            });
            throw new IllegalStateException(message.toString());
        }
    }
}

