/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.OperationFactory;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperationParameterInfo;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperation;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxAnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInfo;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.util.StringUtils;

class JmxEndpointOperationFactory
implements OperationFactory<JmxOperation> {
    JmxEndpointOperationFactory() {
    }

    @Override
    public JmxOperation createOperation(String endpointId, OperationMethodInfo methodInfo, Object target, OperationInvoker invoker) {
        Method method = methodInfo.getMethod();
        String name = method.getName();
        OperationType operationType = methodInfo.getOperationType();
        Class<?> outputType = this.getJmxType(method.getReturnType());
        String description = this.getDescription(method, () -> "Invoke " + name + " for endpoint " + endpointId);
        return new JmxOperation(operationType, invoker, name, outputType, description, this.getParameters(methodInfo));
    }

    private String getDescription(Method method, Supplier<String> fallback) {
        ManagedOperation managedOperation = JmxAnnotationEndpointDiscoverer.jmxAttributeSource.getManagedOperation(method);
        if (managedOperation != null && StringUtils.hasText((String)managedOperation.getDescription())) {
            return managedOperation.getDescription();
        }
        return fallback.get();
    }

    private List<JmxEndpointOperationParameterInfo> getParameters(OperationMethodInfo methodInfo) {
        if (methodInfo.getParameters().isEmpty()) {
            return Collections.emptyList();
        }
        Method method = methodInfo.getMethod();
        ManagedOperationParameter[] operationParameters = JmxAnnotationEndpointDiscoverer.jmxAttributeSource.getManagedOperationParameters(method);
        if (operationParameters.length == 0) {
            return methodInfo.getParameters().entrySet().stream().map(this::getParameter).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.mergeParameters(method.getParameters(), operationParameters);
    }

    private List<JmxEndpointOperationParameterInfo> mergeParameters(Parameter[] methodParameters, ManagedOperationParameter[] operationParameters) {
        ArrayList<JmxEndpointOperationParameterInfo> parameters = new ArrayList<JmxEndpointOperationParameterInfo>();
        for (int i = 0; i < operationParameters.length; ++i) {
            ManagedOperationParameter operationParameter = operationParameters[i];
            Parameter methodParameter = methodParameters[i];
            JmxEndpointOperationParameterInfo parameter = this.getParameter(operationParameter.getName(), methodParameter, operationParameter.getDescription());
            parameters.add(parameter);
        }
        return parameters;
    }

    private JmxEndpointOperationParameterInfo getParameter(Map.Entry<String, Parameter> entry) {
        return this.getParameter(entry.getKey(), entry.getValue(), null);
    }

    private JmxEndpointOperationParameterInfo getParameter(String name, Parameter methodParameter, String description) {
        return new JmxEndpointOperationParameterInfo(name, this.getJmxType(methodParameter.getType()), description);
    }

    private Class<?> getJmxType(Class<?> type) {
        if (type.isEnum()) {
            return String.class;
        }
        if (Date.class.isAssignableFrom(type)) {
            return String.class;
        }
        if (type.getName().startsWith("java.")) {
            return type;
        }
        if (type.equals(Void.TYPE)) {
            return type;
        }
        return Object.class;
    }
}

