/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.annotation.AnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.EndpointPathResolver;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointOperationFactory;
import org.springframework.context.ApplicationContext;

public class WebAnnotationEndpointDiscoverer
extends AnnotationEndpointDiscoverer<OperationRequestPredicate, WebOperation> {
    public WebAnnotationEndpointDiscoverer(ApplicationContext applicationContext, ParameterMapper parameterMapper, EndpointMediaTypes endpointMediaTypes, EndpointPathResolver endpointPathResolver, Collection<? extends OperationMethodInvokerAdvisor> invokerAdvisors, Collection<? extends EndpointFilter<WebOperation>> filters) {
        super(applicationContext, new WebEndpointOperationFactory(endpointMediaTypes, endpointPathResolver), WebOperation::getRequestPredicate, parameterMapper, invokerAdvisors, filters);
    }

    @Override
    protected void verify(Collection<AnnotationEndpointDiscoverer.DiscoveredEndpoint> exposedEndpoints) {
        ArrayList clashes = new ArrayList();
        exposedEndpoints.forEach(descriptor -> clashes.addAll(descriptor.findDuplicateOperations().values()));
        if (!clashes.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Found multiple web operations with matching request predicates:%n", new Object[0]));
            clashes.forEach(clash -> {
                message.append(" ").append(((WebOperation)clash.get(0)).getRequestPredicate()).append(String.format(":%n", new Object[0]));
                clash.forEach(operation -> message.append(" ").append(String.format("%s%n", operation)));
            });
            throw new IllegalStateException(message.toString());
        }
    }
}

