/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.reactive;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestMethodsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractWebFluxEndpointHandlerMapping
extends RequestMappingInfoHandlerMapping {
    private static final PathPatternParser pathPatternParser = new PathPatternParser();
    private final EndpointMapping endpointMapping;
    private final Collection<EndpointInfo<WebOperation>> webEndpoints;
    private final EndpointMediaTypes endpointMediaTypes;
    private final CorsConfiguration corsConfiguration;

    public AbstractWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebOperation>> collection, EndpointMediaTypes endpointMediaTypes) {
        this(endpointMapping, collection, endpointMediaTypes, null);
    }

    public AbstractWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.webEndpoints = webEndpoints;
        this.endpointMediaTypes = endpointMediaTypes;
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    protected void initHandlerMethods() {
        this.webEndpoints.stream().flatMap(webEndpoint -> webEndpoint.getOperations().stream()).forEach(this::registerMappingForOperation);
        if (StringUtils.hasText((String)this.endpointMapping.getPath())) {
            this.registerLinksMapping();
        }
    }

    private void registerLinksMapping() {
        PatternsRequestCondition patterns = new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.getPath())});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.GET});
        ProducesRequestCondition produces = new ProducesRequestCondition(this.endpointMediaTypes.getProduced().toArray(new String[this.endpointMediaTypes.getProduced().size()]));
        RequestMappingInfo mapping = new RequestMappingInfo(patterns, methods, null, null, null, produces, null);
        this.registerMapping(mapping, (Object)this, this.getLinks());
    }

    protected RequestMappingInfo createRequestMappingInfo(WebOperation operationInfo) {
        OperationRequestPredicate requestPredicate = operationInfo.getRequestPredicate();
        PatternsRequestCondition patterns = new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.createSubPath(requestPredicate.getPath()))});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.valueOf((String)requestPredicate.getHttpMethod().name())});
        ConsumesRequestCondition consumes = new ConsumesRequestCondition(this.toStringArray(requestPredicate.getConsumes()));
        ProducesRequestCondition produces = new ProducesRequestCondition(this.toStringArray(requestPredicate.getProduces()));
        return new RequestMappingInfo(null, patterns, methods, null, null, consumes, produces, null);
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }

    public Collection<EndpointInfo<WebOperation>> getEndpoints() {
        return this.webEndpoints;
    }

    protected abstract Method getLinks();

    protected abstract void registerMappingForOperation(WebOperation var1);

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected static final class ElasticSchedulerOperationInvoker
    implements OperationInvoker {
        private final OperationInvoker delegate;

        public ElasticSchedulerOperationInvoker(OperationInvoker delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Map<String, Object> arguments) {
            return Mono.create(sink -> Schedulers.elastic().schedule(() -> this.invoke(arguments, (MonoSink<Object>)sink)));
        }

        private void invoke(Map<String, Object> arguments, MonoSink<Object> sink) {
            try {
                Object result = this.delegate.invoke(arguments);
                sink.success(result);
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }
    }
}

