/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.reactive;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.reflect.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.reactive.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WebFluxEndpointHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping
implements InitializingBean {
    private final Method handleRead = ReflectionUtils.findMethod(ReadOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});
    private final Method handleWrite = ReflectionUtils.findMethod(WriteOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class, Map.class});
    private final Method links = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"links", (Class[])new Class[]{ServerHttpRequest.class});
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();

    public WebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebOperation>> collection, EndpointMediaTypes endpointMediaTypes) {
        this(endpointMapping, collection, endpointMediaTypes, null);
    }

    public WebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration) {
        super(endpointMapping, webEndpoints, endpointMediaTypes, corsConfiguration);
        this.setOrder(-100);
    }

    @Override
    protected Method getLinks() {
        return this.links;
    }

    @Override
    protected void registerMappingForOperation(WebOperation operation) {
        OperationType operationType = operation.getType();
        OperationInvoker operationInvoker = operation.getInvoker();
        if (operation.isBlocking()) {
            operationInvoker = new AbstractWebFluxEndpointHandlerMapping.ElasticSchedulerOperationInvoker(operationInvoker);
        }
        this.registerMapping(this.createRequestMappingInfo(operation), operationType == OperationType.WRITE ? new WriteOperationHandler(operationInvoker) : new ReadOperationHandler(operationInvoker), operationType == OperationType.WRITE ? this.handleWrite : this.handleRead);
    }

    @ResponseBody
    private Map<String, Map<String, Link>> links(ServerHttpRequest request) {
        return Collections.singletonMap("_links", this.endpointLinksResolver.resolveLinks(this.getEndpoints(), UriComponentsBuilder.fromUri((URI)request.getURI()).replaceQuery(null).toUriString()));
    }

    final class ReadOperationHandler
    extends AbstractOperationHandler {
        ReadOperationHandler(OperationInvoker operationInvoker) {
            super(operationInvoker);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange) {
            return this.doHandle(exchange, null);
        }
    }

    final class WriteOperationHandler
    extends AbstractOperationHandler {
        WriteOperationHandler(OperationInvoker operationInvoker) {
            super(operationInvoker);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange, @RequestBody(required=false) Map<String, String> body) {
            return this.doHandle(exchange, body);
        }
    }

    abstract class AbstractOperationHandler {
        private final OperationInvoker operationInvoker;

        AbstractOperationHandler(OperationInvoker operationInvoker) {
            this.operationInvoker = operationInvoker;
        }

        Publisher<ResponseEntity<Object>> doHandle(ServerWebExchange exchange, Map<String, String> body) {
            HashMap<String, Object> arguments = new HashMap<String, Object>((Map)exchange.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
            if (body != null) {
                arguments.putAll(body);
            }
            exchange.getRequest().getQueryParams().forEach((name, values) -> arguments.put((String)name, values.size() == 1 ? values.get(0) : values));
            return this.handleResult((Publisher)this.operationInvoker.invoke(arguments), exchange.getRequest().getMethod());
        }

        private Publisher<ResponseEntity<Object>> handleResult(Publisher<?> result, HttpMethod httpMethod) {
            return Mono.from(result).map(this::toResponseEntity).onErrorReturn(ParametersMissingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).onErrorReturn(ParameterMappingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).defaultIfEmpty((Object)new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT));
        }

        private ResponseEntity<Object> toResponseEntity(Object response) {
            if (!(response instanceof WebEndpointResponse)) {
                return new ResponseEntity(response, HttpStatus.OK);
            }
            WebEndpointResponse webEndpointResponse = (WebEndpointResponse)response;
            return new ResponseEntity(webEndpointResponse.getBody(), HttpStatus.valueOf((int)webEndpointResponse.getStatus()));
        }
    }
}

