/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.tomcat;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import java.util.Collections;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class TomcatMetricsBinder
implements ApplicationListener<ApplicationStartedEvent>,
DisposableBean {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;
    private volatile TomcatMetrics tomcatMetrics;

    public TomcatMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public TomcatMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Manager manager = this.findManager((ApplicationContext)applicationContext);
        this.tomcatMetrics = new TomcatMetrics(manager, this.tags);
        this.tomcatMetrics.bindTo(this.meterRegistry);
    }

    private Manager findManager(ApplicationContext applicationContext) {
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = ((WebServerApplicationContext)applicationContext).getWebServer()) instanceof TomcatWebServer) {
            Context context = this.findContext((TomcatWebServer)webServer);
            return context.getManager();
        }
        return null;
    }

    private Context findContext(TomcatWebServer tomcatWebServer) {
        for (Container container : tomcatWebServer.getTomcat().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            return (Context)container;
        }
        return null;
    }

    public void destroy() {
        this.tomcatMetrics.close();
    }
}

