/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.Status;

public abstract class AbstractHealthAggregator
implements HealthAggregator {
    @Override
    public final Health aggregate(Map<String, Health> healths) {
        List<Status> statusCandidates = healths.values().stream().map(Health::getStatus).collect(Collectors.toList());
        Status status = this.aggregateStatus(statusCandidates);
        Map<String, Object> details = this.aggregateDetails(healths);
        return new Health.Builder(status, details).build();
    }

    protected abstract Status aggregateStatus(List<Status> var1);

    protected Map<String, Object> aggregateDetails(Map<String, Health> healths) {
        return new LinkedHashMap<String, Object>(healths);
    }
}

