/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Sanitizer {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final Pattern URI_USERINFO_PATTERN = Pattern.compile("[A-Za-z]+://.+:(.*)@.+$");
    private Pattern[] keysToSanitize;

    public Sanitizer() {
        this("password", "secret", "key", "token", ".*credentials.*", "vcap_services", "sun.java.command", "uri");
    }

    public Sanitizer(String ... keysToSanitize) {
        this.setKeysToSanitize(keysToSanitize);
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = new Pattern[keysToSanitize.length];
        for (int i = 0; i < keysToSanitize.length; ++i) {
            this.keysToSanitize[i] = this.getPattern(keysToSanitize[i]);
        }
    }

    private Pattern getPattern(String value) {
        if (this.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + "$", 2);
    }

    private boolean isRegex(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    public Object sanitize(String key, Object value) {
        if (value == null) {
            return null;
        }
        for (Pattern pattern : this.keysToSanitize) {
            if (!pattern.matcher(key).matches()) continue;
            if (pattern.matcher("uri").matches()) {
                return this.sanitizeUri(value);
            }
            return "******";
        }
        return value;
    }

    private Object sanitizeUri(Object value) {
        String password;
        Matcher matcher = URI_USERINFO_PATTERN.matcher(value.toString());
        String string = password = matcher.matches() ? matcher.group(1) : null;
        if (password != null) {
            return StringUtils.replace((String)value.toString(), (String)(":" + password + "@"), (String)":******@");
        }
        return value;
    }
}

