/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoker.cache;

import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.endpoint.InvocationContext;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CachingOperationInvoker
implements OperationInvoker {
    private final OperationInvoker invoker;
    private final long timeToLive;
    private volatile CachedResponse cachedResponse;

    CachingOperationInvoker(OperationInvoker invoker, long timeToLive) {
        Assert.isTrue((timeToLive > 0L ? 1 : 0) != 0, (String)"TimeToLive must be strictly positive");
        this.invoker = invoker;
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Object invoke(InvocationContext context) {
        if (this.hasInput(context)) {
            return this.invoker.invoke(context);
        }
        long accessTime = System.currentTimeMillis();
        CachedResponse cached = this.cachedResponse;
        if (cached == null || cached.isStale(accessTime, this.timeToLive)) {
            Object response = this.invoker.invoke(context);
            this.cachedResponse = new CachedResponse(response, accessTime);
            return response;
        }
        return cached.getResponse();
    }

    private boolean hasInput(InvocationContext context) {
        if (context.getSecurityContext().getPrincipal() != null) {
            return true;
        }
        Map<String, Object> arguments = context.getArguments();
        if (!ObjectUtils.isEmpty(arguments)) {
            return arguments.values().stream().anyMatch(Objects::nonNull);
        }
        return false;
    }

    public static OperationInvoker apply(OperationInvoker invoker, long timeToLive) {
        if (timeToLive > 0L) {
            return new CachingOperationInvoker(invoker, timeToLive);
        }
        return invoker;
    }

    static class CachedResponse {
        private final Object response;
        private final long creationTime;

        CachedResponse(Object response, long creationTime) {
            this.response = response;
            this.creationTime = creationTime;
        }

        boolean isStale(long accessTime, long timeToLive) {
            return accessTime - this.creationTime >= timeToLive;
        }

        Object getResponse() {
            return this.response;
        }
    }
}

