/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.Assert;

public class CompositeHealth
extends HealthComponent {
    private Status status;
    private Map<String, HealthComponent> details;

    CompositeHealth(Status status, Map<String, HealthComponent> details) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        this.status = status;
        this.details = details != null ? new TreeMap(details) : details;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, HealthComponent> getDetails() {
        return this.details;
    }
}

